Unit avga;

Interface

Uses XMS_;

Const
 v320x200  = 0;
 v640x480  = 1;
 v800x600  = 2;
 v400x600  = 5;

 Procedure eViewImageVga(Width,Lines : Word;Mode : Byte; XMSHandle : Word);
Implementation

Uses Crt,VesaDrv,modexlib,keyboard;

Type PalRec = Record
               r,g,b : byte;
              End;

Var Palette : Array[0..255] of palrec;          { Current Palette      }
    Shades  : Array[0..15,0..15,1..3] of Byte;  { Shades Created/Index }
    Highest : LongInt;                          { Highest Color Used   }
    Done    : Boolean;                          { Terminate Main Loop? }
    Top     : Word;                             { Top Line on Screen   }
    CH      : Char;
    MaxX,MaxY : Word;                           { Screen Size          }

Procedure InitVideo(Mode : Byte);
Begin
 Case Mode of
   v320x200 : Begin
               asm mov ax,13h; int 10h; end;
               MaxX := 320; MaxY := 200;
              End;
   v640x480 : Begin
               InitVesaMode($101,True);
               MaxX := 640; MaxY := 480;
              End;
   v800x600 : Begin
               InitVesaMode($103,True);
               MaxX := 800; MaxY := 600;
              End;
   v400x600:  Begin
               Init_modex;
               Enter400;
               MaxX:=400; MaxY:=600;
              End;
End;
END;

Procedure Pixel(X,Y : Word;Color : Byte;Mode : Byte);
Begin
 Case Mode of
  v320x200 : mem[$a000:(Y shl 8)+(Y shl 6)+X] := Color;
  v640x480 : vesaputpixel(x,y,color);
  v800x600 : vesaputpixel(x,y,color);
  v400x600 : mem[$a000:(Y shl 8)+(Y shl 6)+X]:= Color;
 End;
End;

Procedure Setpal(Color,R,G,B : Byte);
Begin
 Port[$3c8] := Color;
 Port[$3c9] := R;
 Port[$3c9] := G;
 Port[$3c9] := B;
End;

Procedure WriteVGA(X,Y : Integer;Ch : Char;Fore,Back,Mode : Byte);

Procedure MakeShade(ShadeType : Byte);
Begin
 Case ShadeType of
  1 : Begin { 25% Background, 75% Foreground }
       Palette[highest].R := Round((Palette[Fore].R * 0.75)+(Palette[Back].R * 0.25));
       Palette[highest].G := Round((Palette[Fore].G * 0.75)+(Palette[Back].G * 0.25));
       Palette[highest].B := Round((Palette[Fore].B * 0.75)+(Palette[Back].B * 0.25));
       Shades[Back,Fore,1] := Highest;
       If (Fore < 8) then Shades[Fore,Back,1] := highest;
       Setpal(highest,palette[highest].R,palette[highest].G,palette[highest].B);
       Inc(Highest);
      End;
  2 : Begin { 50% Background, 50% Foreground }
       Palette[highest].R := Round((Palette[Fore].R * 0.50)+(Palette[Back].R * 0.50));
       Palette[highest].G := Round((Palette[Fore].G * 0.50)+(Palette[Back].G * 0.50));
       Palette[highest].B := Round((Palette[Fore].B * 0.50)+(Palette[Back].B * 0.50));
       Shades[Back,Fore,2] := highest;
       If (Fore < 8) then Shades[Fore,Back,2] := highest;
       Setpal(highest,palette[highest].R,palette[highest].G,palette[highest].B);
       Inc(Highest);
      End;
  3 : Begin { 75% Background, 25% Foreground }
       Palette[highest].R := Round((Palette[Fore].R * 0.25)+(Palette[Back].R * 0.75));
       Palette[highest].G := Round((Palette[Fore].G * 0.25)+(Palette[Back].G * 0.75));
       Palette[highest].B := Round((Palette[Fore].B * 0.25)+(Palette[Back].B * 0.75));
       Shades[Back,Fore,3] := Highest;
       If (Fore < 8) then Shades[Fore,Back,3] := highest;
       Setpal(highest,palette[highest].R,palette[highest].G,palette[highest].B);
       Inc(Highest);
      End;
 End;
End;

Begin
 If (Fore = Back) or (CH = '') then
  Begin
   Pixel(X,Y,Fore,Mode);
   Pixel(X,Y+1,Fore,Mode);
   Exit;
  End;
 Case CH of
  #0,' ': Begin Pixel(X,Y,Back,Mode); Pixel(X,Y+1,Back,Mode); End;
(*  '' : Begin
         Pixel(X,Y,Back,Mode);
         Pixel(X,Y+1,Fore,Mode);
        End;
  '' : Begin
         Pixel(X,Y,Fore,Mode);
         Pixel(X,Y,Back,Mode);
        End;*)
  '','-','': If Fore = Back then
                 Begin
                  Pixel(X,Y,Fore,Mode);
                  Pixel(X,Y+1,Fore,Mode);
                 End else Begin
                           Pixel(X,Y,Fore,Mode);
                           Pixel(X,Y+1,back,Mode);
                         END;
  '': If Fore = Back then
            begin
             pixel(X,Y,Fore,Mode);
             pixel(X,Y+1,Fore,Mode);
            end else Begin
                      Pixel(X,Y,Back,Mode);Pixel(X,Y+1,Fore,Mode);
                     End;

  '' : Begin
         If Shades[Back,Fore,1] = 0 then MakeShade(1);
         Pixel(X,Y,Shades[Back,Fore,1],Mode);
         Pixel(X,Y+1,Shades[Back,Fore,1],Mode);
        End;
  '','','' : Begin
         If Shades[Back,Fore,2] = 0 then MakeShade(2);
         Pixel(X,Y,Shades[Back,Fore,1],Mode);
         Pixel(X,Y+1,Shades[Back,Fore,1],Mode);
        End;
  '' : Begin
         If Shades[Back,Fore,3] = 0 then MakeShade(3);
         Pixel(X,Y,Shades[Back,Fore,3],Mode);
         Pixel(X,Y+1,Shades[Back,Fore,3],Mode);
        End;
   else Begin
         Pixel(X,Y,Fore,Mode);
         Pixel(X,Y+1,Fore,Mode);
        End;
 End; {Case CH}
End;


Procedure Display(Width,MaximumLines : Word;Mode : Byte;XMSHandle : Word);
Var Fore,Back : Byte;
    Y,X       : Integer;    { Width is 160 or 320 }
    Character : Char;
    Templine  : Array[0..(999*2)] of Byte;
Begin
 For Y := 0 to ((MaxY-1) div 2) do
  Begin
   If Y+Top > Maximumlines then exit;
    xmsGetDataFrom(XMSHandle,((Y+Top)*Width),width,@TempLine);
   For X := 0 to (Width-1) shr 1 do
    Begin
     Fore := Templine[(X shl 1)+1] and 15;
     Back := Templine[(X shl 1)+1] shr 4;
     Character := Chr(Templine[(X shl 1)]);
     WriteVGA((MaxX div 2)-(Width div 4)+X,Y shl 1,Character,Fore,Back,Mode);
    End;
  End;
End;

Procedure eViewImageVga(Width,Lines : Word;Mode : Byte; XMSHandle : Word);
Const Dacs : Array[0..15] of Byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
Var X : word;
    P,R : Integer;
    key : char;
Begin
 if (width>320) then width := 320;
 Top     := 0;
 Highest := 16;
 Done    := False;
 FillChar(Shades, SizeOf(Shades), 0);
 FillChar(palette, SizeOf(palette), 0);
 For X := 0 to 15 do
  Begin
   Port[$3c7] := Dacs[X];
   Palette[X].R := Port[$3c9];
   Palette[X].G := Port[$3c9];
   Palette[X].B := Port[$3c9];
  End;
 For X := 16 to 255 do
  Begin
   Port[$3c7]   := X;
   Palette[X].R := Port[$3c9];
   Palette[X].G := Port[$3c9];
   Palette[X].B := Port[$3c9];
  End;
 InitVideo(mode);
 Display(Width,Lines,Mode,XMSHandle);
 For X := 0 to 255 do
  Begin
   Port[$3c8] := X;
   Port[$3c9] := Palette[X].R;
   Port[$3c9] := Palette[X].G;
   Port[$3c9] := Palette[X].B;
  End;
 While (not done) do
  Begin
    Display(Width,Lines,Mode,XMSHandle);
    repeat
     MemW[$0000:$041C] := MemW[$0000:$041A];
     key := readkey until key in [#72,#80,#73,#81,#27,#13];
     if key=#72 then If Top > 0 then Dec(Top,1);
     if key=#80 then inc(Top,1);
     if key=#73 then if (top > 15) then
           begin
           for x := 1 to 15 do
            begin
            dec(top,1);
            Display(Width,Lines,Mode,XMSHandle);
            end;
           end else
            begin
           for x := 1 to top do
            begin
            dec(top,1);
            Display(Width,Lines,Mode,XMSHandle);
            end;
            end;
     if key=#81 then for x := 1 to 15 do
            begin
            inc(top,1);
            Display(Width,Lines,Mode,XMSHandle);
            end;
     if key=#13 then Done := True;
     if key=#27 then done := true;
{     '+' : if (mode<3) then inc(mode) else mode := 1;
     '-' : if (mode>1) then dec(mode) else mode := 4;}
    End;
End;

End.