unit config;
     interface uses records,crt,dos,skaunit,genshit,control,bit,extense;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eMainConfigEditor;
Procedure eSauceEditor;
Procedure eAdfFontEditor;
Procedure eAdfPaletteEditor;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
implementation
Procedure eConfigScrn;   External; {$L .\ART\CONFIG.OBJ}
Procedure eSauceScrn;    External; {$L .\ART\SAUCE.OBJ}
Procedure ePalEditScrn;  External; {$L .\ART\PALEDIT.OBJ}
Procedure eFontEdScrn;   External; {$L .\ART\FONTED.OBJ}
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eMainConfigEditor;
const eSauce : array[0..2] of string[10] = ('Always ','Confirm','Never  ');
      eMode  : array[0..2] of string[10] = ('320x200','640x480','800x600');
      eTotlz : array[1..2] of byte = (10,10);
      ePages = 2;
var eCfgPage : byte;
    eInkey   : string[2];
    eDone    : boolean;
    eBars    : array[1..2] of byte;
    eCount   : byte;
    eFile    : file;
    eOldCfg  : eConfigRec;
    eChanged : boolean;

    Procedure eUpdateBars;
     begin
     gotoXY(3,10+eBars[1]);
     skaWrite('|B0|08'#254);
     gotoXY(3,10+eBars[2]);
     skaWrite('|B0|10'#254);
     end;

    Procedure eEditItem(ePage,eItem : byte);
     begin
     gotoXY(7,10+eItem);
     if (ePage=1) then
      case eItem of
       1 : eConfigData^.cIntro := not eConfigData^.cIntro;
       2 : if (eConfigData^.cSauce<2) then inc(eConfigData^.cSauce) else eConfigData^.cSauce := 0;
       3 : if (eConfigData^.cVgaMode<2) then inc(eConfigData^.cVgaMode) else eConfigData^.cVgaMode := 0;
       4 : eConfigData^.cWidth := str2byte(inputStr(39,14,15,3,strr(eConfigData^.cWidth)));
       5 : eConfigData^.c8x16Mode := not eConfigData^.c8x16Mode;
       6 : eConfigData^.cStartFg := str2byte(inputStr(50,16,15,2,strr(eConfigData^.cStartFg)));
       7 : eConfigData^.cStartBg := str2byte(inputStr(50,17,15,2,strr(eConfigData^.cStartBg)));
       8 : eConfigData^.cDefAuthor := inputStr(29,18,15,20,eConfigData^.cDefAuthor);
       9 : eConfigData^.cDefGroup := inputStr(34,19,15,20,eConfigData^.cDefGroup);
      10 : eConfigData^.cPages := str2byte(inputStr(41,20,15,1,strr(eConfigData^.cPages)));
      end else
     if (ePage=2) then
      case eItem of
       1 : eConfigData^.cAsciiExt  := inputStr(38,11,15,3,eConfigData^.cAsciiExt);
       2 : eConfigData^.cAnsiExt   := inputStr(38,12,15,3,eConfigData^.cAnsiExt);
       3 : eConfigData^.cAdfExt    := inputStr(38,13,15,3,eConfigData^.cAdfExt);
       4 : eConfigData^.cBinExt    := inputStr(38,14,15,3,eConfigData^.cBinExt);
       5 : eConfigData^.cXBinExt   := inputStr(38,15,15,3,eConfigData^.cXBinExt);
       6 : eConfigData^.cPalExt    := inputStr(38,16,15,3,eConfigData^.cPalExt);
       7 : eConfigData^.cFontExt   := inputStr(38,17,15,3,eConfigData^.cFontExt);
       8 : eConfigData^.cPascalExt := inputStr(38,18,15,3,eConfigData^.cPascalExt);
       9 : eConfigData^.cPipExt    := inputStr(38,19,15,3,eConfigData^.cPipExt);
      10 : eConfigData^.cAskSave := not eConfigData^.cAskSave;
      end;
     end;

    Procedure eUpdatePage(ePage,eItem : byte);
     begin
     gotoXY(7,10+eItem);
     if (ePage=1) then
      case eItem of
       1 : skaWrite('|04Display Intro Screen Upon Startup: |01'+eBooleans[byte(eConfigData^.cIntro)]);
       2 : skaWrite('|04Append SAUCE Information to Saved Files: |01'+eSauce[eConfigData^.cSauce]);
       3 : skaWrite('|04High Resolution Viewing Mode: |01'+eMode[eConfigData^.cVgaMode]);
       4 : skaWrite('|04Default Image Width in Columns: |01'+strr(eConfigData^.cWidth));
       5 : skaWrite('|04Utilize 8x16 VGA Font on Default: |01'+eBooleans[byte(eConfigData^.c8x16Mode)]);
       6 : skaWrite('|04Default Foreground Attribute Upon Startup: |01'+strr(eConfigData^.cStartFg));
       7 : skaWrite('|04Default Background Attribute Upon Startup: |01'+strr(eConfigData^.cStartBg));
       8 : skaWrite('|04Default SAUCE Author: |01'+eTab(eConfigData^.cDefAuthor,20));
       9 : skaWrite('|04Default SAUCE Affiliation: |01'+eTab(eConfigData^.cDefGroup,20));
      10 : skaWrite('|04Number of Swap Pages to Allocate: |01'+strr(eConfigData^.cPages));
      end else
     if (ePage=2) then
      case eItem of
       1 : skaWrite('|04Ascii Image File Extension:   .|01'+eTab(eConfigData^.cAsciiExt,3));
       2 : skaWrite('|04Ansi Image File Extension:    .|01'+eTab(eConfigData^.cAnsiExt,3));
       3 : skaWrite('|04Artworx Image File Extension: .|01'+eTab(eConfigData^.cAdfExt,3));
       4 : skaWrite('|04Binary Image File Extension:  .|01'+eTab(eConfigData^.cBinExt,3));
       5 : skaWrite('|04XBiN Image File Extension:    .|01'+eTab(eConfigData^.cXBinExt,3));
       6 : skaWrite('|04Palette Data File Extension:  .|01'+eTab(eConfigData^.cPalExt,3));
       7 : skaWrite('|04Font Data File Extension:     .|01'+eTab(eConfigData^.cFontExt,3));
       8 : skaWrite('|04Pascal Code File Extension:   .|01'+eTab(eConfigData^.cPascalExt,3));
       9 : skaWrite('|04Pipe Image File Extension:    .|01'+eTab(eConfigData^.cPipExt,3));
      10 : skaWrite('|04Prompt for save on exit: |01'+eBooleans[byte(eConfigData^.cAskSave)]);
      end;
     end;

 begin
 eChanged := false;
 move(eConfigData^,eOldCfg,sizeOf(eConfigRec));
 asm mov ax, 3; int 10h end;
 window(1,1,80,25);
 cursor_off;
 move(@eConfigScrn^,mem[$b800:0],4000);
 eDone := false;
 eCfgPage := 1;
 eBars[1] := 1; eBars[2] := 1;
 eUpdateBars;
 for eCount := 1 to 12 do eUpdatePage(eCfgPage,eCount);
  repeat
   repeat eInKey := eReadKey until (upCase(eInKey[1]) in [#72,#80,#73,#81,#13,#27,'8','2','B','Q']);
   case eInKey[1] of
    #13 : begin
          eChanged := true;
          eEditItem(eCfgPage,eBars[2]);
          eUpdatePage(eCfgPage,eBars[2]);
          end;
    #73 : if (eCfgPage>1) then
           begin
           dec(eCfgPage);
           window(7,11,56,21); textAttr := 7;
           clrScr; window(1,1,80,25);
           for eCount := 1 to 12 do eUpdatePage(eCfgPage,eCount);
           eBars[1] := eBars[2]; eBars[2] := 1;
           eUpdateBars;
           gotoXY(51,23); skaWrite('|08|B0'+strr(eCfgPage));
           end;
    #81 : if (eCfgPage<ePages) then
           begin
           inc(eCfgPage);
           window(7,11,56,21); textAttr := 7;
           clrScr; window(1,1,80,25);
           for eCount := 1 to 12 do eUpdatePage(eCfgPage,eCount);
           eBars[1] := eBars[2]; eBars[2] := 1;
           eUpdateBars;
           gotoXY(51,23); skaWrite('|08|B0'+strr(eCfgPage));
           end;
    #72 : if (eBars[2]>1) then
           begin
           eBars[1] := eBars[2];
           dec(eBars[2]);
           eUpdateBars;
           end;
    #80 : if (eBars[2]<eTotlz[eCfgPage]) then
           begin
           eBars[1] := eBars[2];
           inc(eBars[2]);
           eUpdateBars;
           end;
    #27 : eDone := true;
   end;
  until (eDone=true);
 if (eChanged=true) then
  begin
  gotoXY(1,24);
  if (eOldCfg.cWidth<>eConfigData^.cWidth) then
    skaWrite('|07You have changed the screen width.  This will cause the image to be cleared');
  gotoXY(1,25); skaWrite('|07Would you like to save these changes to disk: ');
  if (eSel=true) then
   begin
   if (eOldCfg.cWidth<>eConfigData^.cWidth) then eClearXms;
   assign(eFile,eStartDir+'EMPATHY.DAT');
   rewrite(eFile,1);
   eConfigData^.cValidNum := eValidNum;
   blockWrite(eFile,eConfigData^,sizeOf(eConfigData^));
   close(eFile);
   eMaxLines := (eMaxXmsBlock*1000) div (eConfigData^.cWidth*2);
   end else move(eOldCfg,eConfigData^,sizeOf(eConfigRec));
  end;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eSauceEditor;
const
 eType1  : array[1..3] of string[50] = (
  '|07    Image |15T|07itle / Description    ',
  '|07       |15A|07rtist Handle / Name      ',
  '|07    Artist Affiliation / |15G|07roup   ');
 eType2  : array[1..3] of string[50] = (
  '|00    Image |15T|00itle / Description    ',
  '|00       |15A|00rtist Handle / Name      ',
  '|00    Artist Affiliation / |15G|00roup   ');
var
 eDone   : boolean;
 eBars   : array[1..2] of byte;
 eInKey  : string[2];
 eCount  : byte;
 eTmpStr : string[35];

        Procedure eShowBars;
         begin
         gotoXY(29,8+eBars[1]*2);
         skaWrite('|B0|07'+eType1[eBars[1]]);
         gotoXY(29,8+eBars[2]*2);
         skaWrite('|B3|00'+eType2[eBars[2]]);
         end;

        Procedure eShowData(num : byte);
         begin
         textAttr := 8;
         if (num=1) or (num=4) then
          begin
          gotoXY(30,11); write(eTab(copy(eCurrentData^.curTitle,1,35),35));
           end;
         if (num=2) or (num=4) then
          begin
          gotoXY(30,13); write(eTab(eCurrentData^.curAuthor,20));
          end;
         if (num=3) or (num=4) then
          begin
          gotoXY(30,15); write(eTab(eCurrentData^.curGroup,20));
          end;
         end;

         Procedure eEditInfo(num : byte);
          begin
          if (num=1) then
           begin
           eCurrentData^.curTitle := inputStr(30,11,8,35,copy(eCurrentData^.curTitle,1,35));
           eShowData(1);
           end else
          if (num=2) then
           begin
           eCurrentData^.curAuthor := inputStr(30,13,8,20,eCurrentData^.curAuthor);
           eShowData(2);
           end else
          if (num=3) then
           begin
           eCurrentData^.curGroup := inputStr(30,15,8,20,eCurrentData^.curGroup);
           eShowData(3);
           end;
          end;

 begin
 asm mov ax, 3; int 10h end;
 window(1,1,80,25);
 move(@eSauceScrn^,mem[$b800:0],4000);
 eBars[1] := 1;
 eBars[2] := 1;
 cursor_off;
 eDone := false;
 eTmpStr := '';
 eTmpStr[0] := #20;
 eShowData(4);
 for eCount := 1 to 3 do
  begin
  eBars[1] := eCount;
  eShowBars;
  end;
 repeat
  repeat eInKey := eReadKey until (upCase(eInKey[1]) in [#72,#80,#13,#27,'T','A','G','8','2','B','Q']);
   case upCase(eInKey[1]) of
   #27 : eDone := true;
   'Q' : if (eMouseUsed=true) then eDone := true;
   #13 : eEditInfo(eBars[2]);
   'B' : if (eMouseUsed=true) then eEditInfo(eBars[2]);
   '8' : if (eMouseUsed=true) then
         begin
         eBars[1] := eBars[2];
         if (eBars[2]>1) then dec(eBars[2]);
         eShowBars;
         end;
   '2' : begin
         eBars[1] := eBars[2];
         if (eBars[2]<3) then inc(eBars[2]);
         eShowBars;
         end;
   #72 : begin
         eBars[1] := eBars[2];
         if (eBars[2]>1) then dec(eBars[2]);
         eShowBars;
         end;
   #80 : begin
         eBars[1] := eBars[2];
         if (eBars[2]<3) then inc(eBars[2]);
         eShowBars;
         end;
   'T' : begin
         eBars[1] := eBars[2];
         eBars[2] := 1;
         eShowBars;
         eEditInfo(1);
         end;
   'A' : begin
         eBars[1] := eBars[2];
         eBars[2] := 2;
         eShowBars;
         eEditInfo(2);
         end;
   'G' : begin
         eBars[1] := eBars[2];
         eBars[2] := 3;
         eShowBars;
         eEditInfo(3);
         end;
   end;
  if (eMouseUsed=true) then eMouseUsed := false;
  until (eDone=true);
 if (eCurrentData^.curRes>1) then eSetResolution;
 eClearMouse;
 window(1,2,80,eBotPos[eCurrentData^.curRes]+1);
 eSetAdfAll;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eAdfFontEditor;
const eFontWidth : array[1..2] of byte = (16,8);
var eCurrentChar : array[1..2] of byte;  {last, curr}
    eDone        : boolean;
    eInKey       : string[2];
    eByteNum     : array[1..2] of byte;
    eBitNum      : array[1..2] of byte;
    eFontHalf    : boolean;
    eFontData    : array[0..255,1..16] of byte;
    eTmpBool     : boolean;
    eCurCharSet  : byte;

    Procedure eUpdateChar;
    var eRegister : registers;
        eCharData : array[1..16] of byte;
        eTmpByte  : byte;

     Procedure eSetAsciiChar(charNum : byte; var data);
     var offset : word;
      begin
      offset := CharNum * 32;
      inline($FA);
      portW[$3C4] := $0402;
      portW[$3C4] := $0704;
      portW[$3CE] := $0204;
      portW[$3CE] := $0005;
      portW[$3CE] := $0006;
      move(data,ptr($A000,offset)^,16);
      portW[$3C4] := $0302;
      portW[$3C4] := $0304;
      portW[$3CE] := $0004;
      portW[$3CE] := $1005;
      portW[$3CE] := $0E06;
      inline($FB);
      end;

     begin
     for eTmpByte := 1 to eFontWidth[eCurrentData^.curRes] do
      eCharData[eTmpByte] := eFontData[eCurrentChar[2],eTmpByte];
     eSetAsciiChar(eCurrentChar[2],eCharData);
     end;

    Function ePushByte(byt : byte) : string;
     begin
     if (byt<=9) then ePushByte := #32+strr(byt) else
      ePushByte := strr(byt);
     end;

    Procedure eDrawCharSelection;
    var eCount : array[1..2] of byte;
     begin
     for eCount[1] := 0 to 7 do
      for eCount[2] := 0 to 31 do
       begin
       gotoXY(35+eCount[2],4+eCount[1]);
       if not (((32*eCount[1])+eCount[2]) in [7,8,9,10,13]) then
        begin
        if (pos(chr((32*eCount[1])+eCount[2]),eConfigData^.cChars[eCurCharSet])>0) then
            textAttr := 31 else textAttr := 7;
        write(chr((32*eCount[1])+eCount[2]))
        end else write('-');
       end;
     end;

    Procedure eUpdateCharSet;
    var eCount : byte;
     begin
     gotoXY(1,25); skaWrite('|15|B0 |08(|15 Function Keyset #'+eTabWord(eCurCharSet,2)+'|08 )');
     for eCount := 73 to 160 do if (odd(eCount)=false) then mem[$b800:(24*160)+eCount] := 32 else
         mem[$b800:(24*160)+eCount] := 16;
     gotoXY(37,25); skaWrite('|B1|00'); mem[$b800:3998] := ord('');
     for eCount := 1 to 10 do
      if (eConfigData^.cChars[eCurCharSet,eCount]<>chr(eCurrentChar[2])) then
       skaWrite('|B1|15 '+strr(eCount)+':|09'+eConfigData^.cChars[eCurCharSet,eCount]) else
       skaWrite('|B1 |B3|00'+strr(eCount)+':'+eConfigData^.cChars[eCurCharSet,eCount]);
     textAttr := 7;
     end;

    Procedure eDrawBitMap;
    var eCount : array[1..2] of byte;
     begin
     for eCount[1] := 1 to eFontWidth[eCurrentData^.curRes] do
      for eCount[2] := 0 to 7 do
       begin
       gotoXY(6+(eCount[2]*3),3+eCount[1]);
       if (eCheckBit(eFontData[eCurrentChar[2],eCount[1]],(7-eCount[2]))=true) then
        skaWrite('|15|B0') else skaWrite('|08|B0');
       end;
     textAttr := 15; gotoXY(41,13);
     if not (eCurrentChar[2] in [7,8,9,10,13]) then write(eTab(ePadByte(eCurrentChar[2]),15)) else
      write('Not Usable');
     gotoXY(43,14); if not (eCurrentChar[2] in [7,8,9,10,13]) then write(eTab(chr(eCurrentChar[2]),15)) else
      write('Not Usable');
     textAttr := 7;
      for eCount[1] := 1 to 3 do
      for eCount[2] := 1 to 31 do
       begin
       gotoXY(35+eCount[2],16+eCount[1]);
       if not (eCurrentChar[2] in [7,8,9,10,13]) then write(chr(eCurrentChar[2])) else
        write(#32);
       end;
     gotoXY(36,17);
     if (eCurrentChar[2] in [7,8,9,10,13]) then write('N/A');
     end;

    Procedure eUpdateHalf;
    var eCount : byte;
     begin
     if (eFontHalf=true) then
      begin
      gotoXY(3,3+eByteNum[1]);
      skaWrite('|08'+ePushByte(eByteNum[1]));
      gotoXY(3,3+eByteNum[2]);
      skaWrite('|15'+ePushByte(eByteNum[2]));
      gotoXY(7+(pred(eBitNum[1])*3),3);
      skaWrite('|08'+strr(eBitNum[1]));
      gotoXY(7+(pred(eBitNum[2])*3),3);
      skaWrite('|15'+strr(eBitNum[2]));
      gotoXY(6+(pred(eBitNum[1])*3),3+eByteNum[1]);
      if (eCheckBit(eFontData[eCurrentChar[2],eByteNum[1]],8-eBitNum[1])=true) then
       skaWrite('|15|B0') else skaWrite('|08|B0');
      gotoXY(6+(pred(eBitNum[2])*3),3+eByteNum[2]);
      if (eCheckBit(eFontData[eCurrentChar[2],eByteNum[2]],8-eBitNum[2])=true) then
       skaWrite('|15|B0') else skaWrite('|07|B0');
      end else
       begin
       for eCount := 1 to 8 do
        if (eCurrentChar[1] in [pred(eCount)*32..pred(eCount*32)]) then
         gotoXY(35+(eCurrentChar[1]-(pred(eCount)*32)),eCount+3);
       if not (eCurrentChar[1] in [7,8,9,10,13]) then
        begin
        if (pos(chr(eCurrentChar[1]),eConfigData^.cChars[eCurCharSet])>0) then
            textAttr := 31 else textAttr := 7;
        write(chr(eCurrentChar[1]))
        end else write('-');
       for eCount := 1 to 8 do
        if (eCurrentChar[2] in [pred(eCount)*32..pred(eCount*32)]) then
         gotoXY(35+(eCurrentChar[2]-(pred(eCount)*32)),eCount+3);
       textAttr := 3*16;
       if not (eCurrentChar[2] in [7,8,9,10,13]) then write(chr(eCurrentChar[2])) else
        write('-'); textAttr := 7;
        eUpdateCharSet;
       end;
     end;

    Procedure eDoInvertFunction(funcId : byte);
    var eCount : array[1..2] of byte;
        eBool  : boolean;
     begin
     if (funcId=1) then
      for eCount[1] := 1 to eFontWidth[eCurrentData^.curRes] do eFontData[eCurrentChar[2],eCount[1]] := 0
     else if (funcId=2) then
      for eCount[1] := 1 to eFontWidth[eCurrentData^.curRes] do eFontData[eCurrentChar[2],eCount[1]] := 255
     else if (funcId=3) then
      begin

      end;
     eUpdateChar; eDrawBitMap; eUpdateHalf;
     end;

 begin
{ if (eCurrentData^.curRes>1) then
  begin
  window(1,1,80,25);
  gotoXY(1,1); textAttr := 7; clrEol;
  skaWrite('|15E|07rror, |15t|07he |03VGA |15f|07ont |15c|07annot |15b|07e |15e|07dited |15i|07n |0350 |15l|07inemode |08-'+
           ' |15S|07witch |15t|07o |0325|08? ');
  if (eSel=false) then exit;
  eCurrentData^.curRes := 1;
  end;
 asm mov ax, 3; int 10h end;} window(1,1,80,25);
 move(@eFontEdScrn^,mem[$b800:0],4000);
 eByteNum[1] := 1; eByteNum[2] := 1;
 eBitNum[1]  := 1; eBitNum[2]  := 1;
 eCurrentChar[1] := 1; eCurrentChar[2] := 65;
 eCurCharSet := 1;
 move(eCurrentData^.curFont,eFontData,4096);
 eSetAdfFont;
 eDrawCharSelection;
 eFontHalf := false; eUpdateHalf;
 eFontHalf := true; eDrawBitMap;
 eUpdateHalf;
 eUpdateCharSet;
 eDone := false;
 cursor_off;
  repeat
   eInKey := eReadKey;
   case eInKey[1] of
    #9  : begin
          eFontHalf := not eFontHalf;
          eUpdateHalf;
          end;
    #13 : begin
          move(eFontData,eCurrentData^.curFont,4096);
          eDone := true;
          end;
 #32,'B' : if (eFontHalf=true) then begin
          eTmpBool := eCheckBit(eFontData[eCurrentChar[2],eByteNum[2]],8-eBitNum[2]);
          eFontData[eCurrentChar[2],eByteNum[2]] := eSetBit(eFontData[eCurrentChar[2],eByteNum[2]],8-eBitNum[2],not eTmpBool);
          if (eBitNum[2]<8) then
           begin
           eBitNum[1] := eBitNum[2];
           eByteNum[1] := eByteNum[2];
           inc(eBitNum[2],1);
           end else
            begin
            eBitNum[1] := eBitNum[2];
            eByteNum[1] := eByteNum[2];
            eBitNum[2] := 1;
            if (eByteNum[2]<eFontWidth[eCurrentData^.curRes]) then inc(eByteNum[2]) else eByteNum[2] := 1;
            end;
          eUpdateHalf;
          eUpdateChar;
          if (eMouseUsed=true) then eClearMouse;
          end;
    #0 : begin
         eInKey := eReadKey;
         case eInKey[1] of
          #45 : eDone := true;
          #46 : eDoInvertFunction(1);
          #33 : eDoInvertFunction(2);
          #23 : eDoInvertFunction(3);
          #59..#68
              : begin
                eCurrentChar[1] := eCurrentChar[2];
                eCurrentChar[2] := ord(eConfigData^.cChars[eCurCharSet,ord(eInKey[1])-58]);
                eTmpBool := eFontHalf;
                eDrawBitMap;
                eFontHalf := true;  eUpdateHalf;
                eFontHalf := false; eUpdateHalf;
                eUpdateCharSet;
                eFontHalf := eTmpBool;
                end;
          #104..
          #114 : begin
                 eCurCharSet := (ord(eInKey[1])-103);
                 eDrawCharSelection;
                 eTmpBool := eFontHalf;
                 eFontHalf := false;
                 eUpdateHalf;
                 eUpdateCharSet;
                 eFontHalf := eTmpBool;
                 end;
          #94..
          #103 : begin
                 eCurCharSet := (ord(eInKey[1])-93)+10;
                 eDrawCharSelection;
                 eTmpBool := eFontHalf;
                 eFontHalf := false;
                 eUpdateHalf;
                 eUpdateCharSet;
                 eFontHalf := eTmpBool;
                 end;
          #71 : if (eBitNum[2]>1) then
                 begin
                 eBitNum[1]  := eBitNum[2];
                 eByteNum[1] := eByteNum[2];
                 eBitNum[2] := 1;
                 eUpdateHalf;
                 end;
          #79 : if (eBitNum[2]<8) then
                 begin
                 eBitNum[1]  := eBitNum[2];
                 eByteNum[1] := eByteNum[2];
                 eBitNum[2] := 8;
                 eUpdateHalf;
                 end;
          #72 : if (eFontHalf=true) then
                 begin
                 if (eByteNum[2]>1) then
                  begin
                  eByteNum[1] := eByteNum[2];
                  eBitNum[1]  := eBitNum[2];
                  dec(eByteNum[2],1);
                  eUpdateHalf;
                  end;
                 end else
                  begin
                  eCurrentChar[1] := eCurrentChar[2];
                  if (eCurrentChar[2]>31) then dec(eCurrentChar[2],32);
                  eDrawBitmap;
                  eUpdateHalf;
                  end;
          #80 : if (eFontHalf=true) then
                  begin
                  if (eByteNum[2]<eFontWidth[eCurrentData^.curRes]) then
                   begin
                   eByteNum[1] := eByteNum[2];
                   eBitNum[1]  := eBitNum[2];
                   inc(eByteNum[2],1);
                   eUpdateHalf;
                   end;
                   end else
                    begin
                    eCurrentChar[1] := eCurrentChar[2];
                    if (eCurrentChar[2]+32<255) then inc(eCurrentChar[2],32);
                    eDrawBitMap;
                    eUpdateHalf;
                    end;
          #77 : if (eFontHalf=true) then
                    begin
                    if (eBitNum[2]<8) then
                     begin
                     eBitNum[1] := eBitNum[2];
                     eByteNum[1] := eByteNum[2];
                     inc(eBitNum[2],1);
                     eUpdateHalf;
                     end else
                      begin
                      eBitNum[1] := eBitNum[2];
                      eByteNum[1] := eByteNum[2];
                      eBitNum[2] := 1;
                      if (eByteNum[2]<eFontWidth[eCurrentData^.curRes]) then inc(eByteNum[2],1) else eByteNum[2] := 1;
                      eUpdateHalf;
                      end;
                      end else
                       begin
                       eCurrentChar[1] := eCurrentChar[2];
                       if (eCurrentChar[2]+1<255) then inc(eCurrentChar[2],1);
                       eDrawBitMap;
                       eUpdateHalf;
                       end;
          #75 : if (eFontHalf=true) then
                       begin
                       if (eBitNum[2]>1) then
                        begin
                        eBitNum[1] := eBitNum[2];
                        eByteNum[1] := eByteNum[2];
                        dec(eBitNum[2],1);
                        eUpdateHalf;
                        end else
                         begin
                         eBitNum[1] := eBitNum[2];
                         eByteNum[1] := eByteNum[2];
                         eBitNum[2] := 8;
                         if (eByteNum[2]>1) then dec(eByteNum[2],1) else eByteNum[2] := eFontWidth[eCurrentData^.curRes];
                         eUpdateHalf;
                         end;
                         end else
                          begin
                          eCurrentChar[1] := eCurrentChar[2];
                          if (eCurrentChar[2]>0) then dec(eCurrentChar[2],1);
                          eDrawBitMap;
                          eUpdateHalf;
                          end;
                        end;
         end;
   end;
  until (eDone=true);
 if (eCurrentData^.curRes>1) then eSetResolution;
 eSetAdfAll;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure eAdfPaletteEditor;
const eYPos   : array[1..6] of byte = (5,30,57,20,47,73);
      eStrs1  : array[1..3] of string[30] =
                ('  |15R|07ed Hue  ','  |15G|07reen Hue  ','  |15B|07lue Hue  ');
      eStrs2  : array[1..3] of string[30] =
                ('  |15R|00ed Hue  ','  |15G|00reen Hue  ','  |15B|00lue Hue  ');
      eColor  : array[0..15] of byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
var   eCount  : byte;
      eBars   : array[1..2,1..2] of byte;
      eSect   : byte;
      eInKey  : string[2];
      eTest   : byte;
      eDone   : boolean;

   Function ePadValue(b : byte) : string;
    begin
    if (b<=9)   then ePadValue := '0'+strr(b) else
    if (b<=63)  then ePadValue := strr(b);
    end;

    Procedure eUpdateBars(sect : byte);
     begin
     if (sect=1) then
      begin
      gotoXY(eYPos[eBars[1,1]],eBotPos[eCurrentData^.curRes]-7);
      skaWrite('|B0'+eStrs1[eBars[1,1]]);
      gotoXy(eYPos[eBars[1,2]],eBotPos[eCurrentData^.curRes]-7);
      skaWrite('|B3'+eStrs2[eBars[1,2]]);
      if (eSect=1) then
       begin gotoXY(3+((eBars[2,2])*5),eBotPos[eCurrentData^.curRes]-3);
       skaWrite('|B0|08'); end;
      end else
     if (sect=2) then
      begin
      gotoXY(3+((eBars[2,1])*5),eBotPos[eCurrentData^.curRes]-3);
      skaWrite('|B0 ');
      gotoXY(3+((eBars[2,2])*5),eBotPos[eCurrentData^.curRes]-3);
      skaWrite('|B0|15');
      end else
     if (sect=3) then
      begin
      gotoXY(eYPos[eBars[1,2]+3],eBotPos[eCurrentData^.curRes]-7);
      skaWrite('|B0|15'+ePadValue(eCurrentData^.curPal[eColor[eBars[2,2]],eBars[1,2]]));
      end;
     gotoXY(1,1);
     end;

 begin
 for eCount := eBotPos[eCurrentData^.curRes]+1 downto eBotPos[eCurrentData^.curRes]-11 do
  begin
  move(@ePalEditScrn^,mem[$b800:eCount*160],4000);
  waitRetrace;
  end;
 eBars[2,2] := 0;
 for eCount := 1 to 3 do begin eBars[1,2] := eCount; eUpdateBars(3); end;
 eBars[1,1] := 1; eBars[1,2] := 1; eBars[2,1] := 0; eBars[2,2] := 0;
 eUpdateBars(2); eUpdateBars(1);
 eSect := 1;
 eDone := false;
 repeat
 repeat eInKey := eReadKey until (upCase(eInKey[1]) in [#77,#75,'+','-',#9,#27,'R','G','B','2','8','4','6','Q']);
 if (eMouseUsed=true) then
  case eInKey[1] of
   'Q' : eDone := true;
   '8' : begin eSect := 1; eUpdateBars(eSect) end;
   '2' : begin eSect := 2; eUpdateBars(eSect) end;
   '6' : if (eSect=1) then
          begin
          eBars[1,1] := eBars[1,2];
          if (eBars[1,2]<3) then inc(eBars[1,2]);
          eUpdateBars(1);
          end else if (eSect=2) then
           begin
           eBars[2,1] := eBars[2,2];
           if (eBars[2,2]<15) then inc(eBars[2,2]) else
               eBars[2,2] := 0;
           eUpdateBars(2);
           eTest := eBars[1,2];
           for eCount := 1 to 3 do begin eBars[1,2] := eCount; eUpdateBars(3); end;
           eBars[1,2] := eTest;
          end;
   '4' : if (eSect=1) then
          begin
          eBars[1,1] := eBars[1,2];
          if (eBars[1,2]>1) then dec(eBars[1,2]);
          eUpdateBars(1);
          end else if (eSect=2) then
           begin
           eBars[2,1] := eBars[2,2];
           if (eBars[2,2]<>0) then dec(eBars[2,2]) else
               eBars[2,2] := 15;
           eUpdateBars(2);
           eTest := eBars[1,2];
           for eCount := 1 to 3 do begin eBars[1,2] := eCount; eUpdateBars(3); end;
           eBars[1,2] := eTest;
          end;
  end else
  case upCase(eInKey[1]) of
  'R','G','B'
       : begin
         eInKey := upCase(eInKey[1]);
         eBars[1,1] := eBars[1,2];
         if (eInKey='R') then eBars[1,2] := 1 else
         if (eInKey='G') then eBars[1,2] := 2 else
         if (eInKey='B') then eBars[1,2] := 3;
         eUpdateBars(1);
         end;
   #27 : eDone := true;
   '+' : begin
          if (eCurrentData^.curPal[eColor[eBars[2,2]],eBars[1,2]]<63) then
          inc(eCurrentData^.curPal[eColor[eBars[2,2]],eBars[1,2]]);
          eUpdateBars(3);
          eSetAdfPalette(eColor[eBars[2,2]],eCurrentData^.curPal[eColor[eBars[2,2]],1],
                         eCurrentData^.curPal[eColor[eBars[2,2]],2],
                         eCurrentData^.curPal[eColor[eBars[2,2]],3]);
         end;
   '-' : begin
          if (eCurrentData^.curPal[eColor[eBars[2,2]],eBars[1,2]]<>0) then
          dec(eCurrentData^.curPal[eColor[eBars[2,2]],eBars[1,2]]);
          eUpdateBars(3);
          eSetAdfPalette(eColor[eBars[2,2]],eCurrentData^.curPal[eColor[eBars[2,2]],1],
                         eCurrentData^.curPal[eColor[eBars[2,2]],2],
                         eCurrentData^.curPal[eColor[eBars[2,2]],3]);
         end;
   #77 : if (eSect=1) then
          begin
          eBars[1,1] := eBars[1,2];
          if (eBars[1,2]<3) then inc(eBars[1,2]);
          eUpdateBars(1);
          end else if (eSect=2) then
           begin
           eBars[2,1] := eBars[2,2];
           if (eBars[2,2]<15) then inc(eBars[2,2]) else
               eBars[2,2] := 0;
           eUpdateBars(2);
           eTest := eBars[1,2];
           for eCount := 1 to 3 do begin eBars[1,2] := eCount; eUpdateBars(3); end;
           eBars[1,2] := eTest;
           end;
   #75 : if (eSect=1) then
          begin
          eBars[1,1] := eBars[1,2];
          if (eBars[1,2]>1) then dec(eBars[1,2]);
          eUpdateBars(1);
          end else if (eSect=2) then
           begin
           eBars[2,1] := eBars[2,2];
           if (eBars[2,2]<>0) then dec(eBars[2,2]) else
               eBars[2,2] := 15;
           eUpdateBars(2);
           eTest := eBars[1,2];
           for eCount := 1 to 3 do begin eBars[1,2] := eCount; eUpdateBars(3); end;
           eBars[1,2] := eTest;
           end;
    #9 : begin
         if (eSect=1) then eSect := 2 else eSect := 1;
         eUpdateBars(eSect);
         end;
  end;
 gotoXY(1,1);
 if (eMouseUsed=true) then eMouseUsed := false;
 until (eDone=true);
 for eCount := eBotPos[eCurrentData^.curRes]-11 to eBotPos[eCurrentData^.curRes]+1 do
  begin
  move(@ePalEditScrn^,mem[$b800:eCount*160],4000);
  waitRetrace;
  eShowLine(eCurrentData^.curStart+eCount-1,eCount);
  end;
 eClearMouse;
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
end.