Unit Sort; { quick sort unit written by g00r00 }

Interface

Type
  TSortMethod = (qAscending, qDescending);

  PQuickSortRec = ^TQuickSortRec;
  TQuickSortRec = Record
    Name : String[80]; { this should be changed to a pointer and 255 len }
    Ptr  : Word;
  End;

  PQuickSort = ^TQuickSort;
  TQuickSort = Object
    Total : Word;
    Data  : Array[1..5000] of PQuickSortRec;

    Constructor Init;
    Destructor  Done;

    Function    Add  (Name: String; Ptr: Word) : Boolean;
    Procedure   Sort (Left, Right: Word; Mode: TSortMethod);
    Procedure   Clear;
  End;

Implementation

Constructor TQuickSort.Init;
Begin
  Total := 0;
End;

Destructor TQuickSort.Done;
Begin
  Clear;
End;

Procedure TQuickSort.Clear;
Var
  Count : Word;
Begin
  For Count := 1 to Total Do
    Dispose (Data[Count]);

  Total := 0;
End;

Function TQuickSort.Add (Name: String; Ptr: Word) : Boolean;
Begin
  Add := False;

  Inc (Total);
  New (Data[Total]);

  If Data[Total] = NIL Then Begin
    Dec (Total);
    Exit;
  End;

  Data[Total]^.Name := Name;
  Data[Total]^.Ptr  := Ptr;

  Add := True;
End;

Procedure TQuickSort.Sort (Left, Right: Word; Mode: TSortMethod);
Var
  Temp   : PQuickSortRec;
  Pivot  : TQuickSortRec;
  Lower  : Word;
  Upper  : Word;
  Middle : Word;
Begin
  If Total = 0 Then Exit;

  Lower  := Left;
  Upper  := Right;
  Middle := (Left + Right) DIV 2;
  Pivot  := Data[Middle]^;

  Repeat
    Case Mode of
      qAscending : Begin
            While Data[Lower]^.Name < Pivot.Name Do Inc(Lower);
            While Pivot.Name < Data[Upper]^.Name Do Dec(Upper);
          End;
      qDescending : Begin
            While Data[Lower]^.Name > Pivot.Name Do Inc(Lower);
            While Pivot.Name > Data[Upper]^.Name Do Dec(Upper);
          End;
    End;

    If Lower <= Upper Then Begin
      Temp        := Data[Lower];
      Data[Lower] := Data[Upper];
      Data[Upper] := Temp;

      Inc (Lower);
      Dec (Upper);
    End;

  Until Lower > Upper;

  If Left  < Upper Then Sort(Left,  Upper, Mode);
  If Lower < Right Then Sort(Lower, Right, Mode);
End;

End.
