// fnt2xb.cpp : Defines the entry point for the console application.
//

#include <string>


using namespace std;

struct XB_Header {
	unsigned char  ID[4];
	unsigned char  EofChar;
	//beware: if this is a short then MS compiler will try to be really smart and align it on some boundary which is 
	//			completely, wholely and in all ways shapes and forms wrong
	unsigned char Width[2];
	unsigned char Height[2];
	unsigned char  Fontsize;
	unsigned char  Flags;
};


int main(int argc, char* argv[])
{
	
	if (argc<=3) {
		printf("to use: fnt2xb [font width] [font height] [fontname.fnt]\n");
		printf("and the fnt file will be converted to a .xb\n");
		printf("e.g. fnt2xb 8 8 acidview.fnt\n");
		return 0;
	}

	int w = atoi(argv[1]);
	int h = atoi(argv[2]);
	unsigned char *data = new unsigned char[(w*h)/8*256];
	FILE *fp = fopen(argv[3], "rb");
	if (!fp) {
		printf("%s not found\n", argv[3]);
		return 0;
	}
	fread(data, (w*h)/8*256, 1, fp);
	fclose(fp);

	string filename = argv[3];
	filename += ".xb";
	fp = fopen(filename.c_str(), "wb+");
	if (!fp) {
		printf("%s could not be created\n", filename.c_str());
		return 0;
	}

	XB_Header header;
	memset(&header, 0, sizeof(header));
	memcpy(header.ID, "XBIN", 4);
	header.EofChar = 0x1a;
	header.Fontsize = w*h/8;
	header.Flags = 2;
	fseek(fp, 0, SEEK_SET);
	int ss = sizeof(header);
	fwrite(&header, sizeof(header), 1, fp);
	fwrite(data, (w*h)/8*256, 1, fp);
	fclose(fp);	

	delete [] data;
	return 0;
}

