// CharSetWindow.cpp : implementation file
//

#include "stdafx.h"
#include "pablodraw.h"
#include "CharSetWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CCharSetWindow message handlers

/////////////////////////////////////////////////////////////////////////////
// CCharSetWindow

CCharSetWindow::CCharSetWindow()
{
    m_bFloatVert = FALSE;
    m_pCharSetView = NULL;

}

CCharSetWindow::~CCharSetWindow()
{
}


BEGIN_MESSAGE_MAP(CCharSetWindow, CSizingControlBar)
    ON_WM_CREATE()
    ON_WM_SIZE()
	ON_MESSAGE(WM_USER_FULLSCREEN_SWITCH, OnFullScreenSwitch)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCharSetWindow message handlers


int CCharSetWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CSizingControlBar::OnCreate(lpCreateStruct) == -1)
        return -1;
    CRect rect;
    GetClientRect(rect);
    
    m_pCharSetView = new CCharSetView();
    m_pCharSetView->Create(NULL, NULL, WS_CHILD|WS_VISIBLE|WS_DISABLED, rect, this, 0);
	SetBorders(3,3,3,3);
	m_cxEdge = 0;

    return 0;
}

BOOL CCharSetWindow::SetParentFrame(CMainFrame* p_pParentFrame)
{
    if (!m_pCharSetView) return FALSE;

    m_pCharSetView->SetParentFrame(p_pParentFrame);

    return TRUE;
}



void CCharSetWindow::OnSize(UINT nType, int cx, int cy) 
{
    CSizingControlBar::OnSize(nType, cx, cy);
    if (m_pCharSetView)
    {
        m_pCharSetView->MoveWindow(0,0,cx,cy);
    }
}
BOOL CCharSetWindow::UpdateFixedSizes(BOOL bHorz, BOOL bDocked)
{
    if (m_pCharSetView)
	{
		if (!bHorz || (m_bFloatVert && !bDocked))
		{
			m_szFixed = m_pCharSetView->GetSize(TRUE);
		}
		else
		{
			m_szFixed = m_pCharSetView->GetSize(FALSE);
		}
	}
    return CSizingControlBar::UpdateFixedSizes(bHorz, bDocked);
}


CSize CCharSetWindow::CalcDynamicLayout(int nLength, DWORD dwMode)
{
    //dwMode &= ~LM_STRETCH;
    if (nLength > 0)
    {
        if (dwMode & LM_LENGTHY)
        {
            m_bFloatVert = (nLength > 100);
        }
        else
        {
            m_bFloatVert = (nLength < 100);
        }
    }

    return CSizingControlBar::CalcDynamicLayout(nLength, dwMode);
}

LRESULT CCharSetWindow::OnFullScreenSwitch(WPARAM wParam, LPARAM lParam)
{
	BOOL bFullScreen = (BOOL)wParam;
	m_pCharSetView->SetSimpleMode(bFullScreen);
	
	if (bFullScreen)
		SetBorders(0,0,0,0);
	else
		SetBorders(3,3,3,3);
	return 0;
}