// ChatView.cpp : implementation file
//

#include "stdafx.h"
#include "PabloDraw.h"
#include "ChatView.h"
#include "MainFrm.h"

#define ID_EDIT		1
#define ID_HISTORY	2


IMPLEMENT_DYNAMIC(CChatView, CWnd)
// CChatView

CChatView::CChatView()
{
	m_pParentFrame = NULL;
}

CChatView::~CChatView()
{
}


BEGIN_MESSAGE_MAP(CChatView, CWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_MESSAGE(WM_RETURN, OnSelected)
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()



// CChatView message handlers


int CChatView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	CFont font;
	font.Attach(GetStockObject(DEFAULT_GUI_FONT));
	CRect rect;
	GetClientRect(rect);
	CRect rectListBox = rect;
	rectListBox.bottom-=20;
	m_chatHistory.Create(WS_VISIBLE | WS_CHILD | ES_MULTILINE | ES_READONLY | ES_AUTOVSCROLL | WS_VSCROLL, rectListBox, this, ID_HISTORY);
	m_chatHistory.SetFont(&font);
	m_chatHistory.ModifyStyleEx(0, WS_EX_CLIENTEDGE);
	PARAFORMAT2 pf;
	pf.cbSize = sizeof(pf);
	pf.dwMask = PFM_OFFSET;
	pf.dxOffset = 75;
	m_chatHistory.SetParaFormat(pf);
	m_chatHistory.SendMessage(EM_AUTOURLDETECT, (WPARAM)TRUE);
	CPoint pt(0,m_chatHistory.GetScrollLimit(SB_VERT));
	m_chatHistory.SendMessage(EM_SETSCROLLPOS, 0, (LPARAM)(POINT*)&pt);

	CRect rectEdit = rect;
	rectEdit.top = rectEdit.bottom-20;
	m_edit.CreateEx(WS_EX_CLIENTEDGE, _T("EDIT"), NULL, ES_WANTRETURN | ES_MULTILINE | WS_VISIBLE | WS_CHILD | ES_AUTOHSCROLL | ES_AUTOVSCROLL, rectEdit, this, ID_EDIT);
	m_edit.SetFont(&font);

	return 0;
}

void CChatView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	CRect rect;
	GetClientRect(rect);
	CRect rectListBox = rect;
	rectListBox.bottom-=20;
	//CPoint pt;
	//m_chatHistory.SendMessage(EM_GETSCROLLPOS, 0, (LPARAM)(POINT*)&pt);
	//BOOL bScrollEnd = (pt.y >= m_chatHistory.GetScrollLimit(SB_VERT)-1);
	m_chatHistory.MoveWindow(rectListBox);
	//if (bScrollEnd) 
	{
		CPoint pt(0,m_chatHistory.GetScrollLimit(SB_VERT));
		m_chatHistory.SendMessage(EM_SETSCROLLPOS, 0, (LPARAM)(POINT*)&pt);
	}

	CRect rectEdit = rect;
	rectEdit.top = rectEdit.bottom-20;
	m_edit.MoveWindow(rectEdit);
}

void CChatView::AddMessage(LPCTSTR p_tszMessage)
{
	CString str;
	CTime time = CTime::GetCurrentTime();

	int i = m_chatHistory.GetWindowTextLength();
	m_chatHistory.SetSel(i, i);

	CString strMessage;
	strMessage.Format(_T("\n[%.2i:%.2i] %s"), time.GetHour(), time.GetMinute(), p_tszMessage);
	CPoint pt;
	m_chatHistory.SendMessage(EM_GETSCROLLPOS, 0, (LPARAM)(POINT*)&pt);

//	if (pt.y >= m_chatHistory.GetScrollLimit(SB_VERT)-1)
	{
		m_chatHistory.ReplaceSel(strMessage);
		CPoint pt(0,m_chatHistory.GetScrollLimit(SB_VERT));
		m_chatHistory.SendMessage(EM_SETSCROLLPOS, 0, (LPARAM)(POINT*)&pt);
	}
/*
	else
	{
		m_chatHistory.ReplaceSel(strMessage);
	}
*/

}


LRESULT CChatView::OnSelected(WPARAM wParam, LPARAM lParam)
{
	LPCTSTR tszMessage = (LPCTSTR)wParam;
	ASSERT(tszMessage);
	if (GetParentFrameWnd()->GetDocument()->GetClientSocket())
	{
		GetParentFrameWnd()->GetDocument()->GetClientSocket()->Message(tszMessage);
	}
	return 0;
}

void CChatView::OnSetFocus(CWnd* pOldWnd)
{
	CWnd::OnSetFocus(pOldWnd);
	m_edit.SetFocus();
}
