#pragma once

// ColourView.h : header file
//
#include "PabloDrawDoc.h"

/////////////////////////////////////////////////////////////////////////////
// CColourView view

class CColourView : public CWnd
{
public:
	CColourView();           // protected constructor used by dynamic creation

	void SetParentFrame(CMainFrame* p_pParentFrame) { m_pParentFrame = p_pParentFrame; }
	CMainFrame* GetMainFrame() { return m_pParentFrame; }

    CSize GetSize(BOOL p_bIsVert);

	void SetSimpleMode(BOOL p_bSimpleMode) { m_bIsSimpleMode = p_bSimpleMode; }

protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

	void DrawCharacter(CDC* pDC, CPoint p_ptStart, UCHAR p_ucCharacter, tElementPart p_fore, tElementPart p_back);
	void DrawString(CDC* pDC, CPoint& p_ptStart, LPCTSTR p_tszValue, tElementPart p_fore, tElementPart p_back);

	virtual ~CColourView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

    BOOL			m_bIsVert;
    CMainFrame*		m_pParentFrame;
	BOOL			m_bIsSimpleMode;
	CString			m_strColour;
	// Generated message map functions
protected:
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnPaint();

	DECLARE_MESSAGE_MAP()
};

