#pragma once


#include "ColourWindow.h"
#include "CharSetWindow.h"
#include "ChatWindow.h"
#include "PreviewWindow.h"
#include "UserListWindow.h"
#include "cMenu.h"

extern BOOL g_bFullScreen;

class CMainFrame : public CFrameWnd
{
	DECLARE_DYNCREATE(CMainFrame)
public:
	CMainFrame(CPabloDrawDoc* p_pDocument = NULL);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// Implementation
public:
	virtual ~CMainFrame();
	CPabloDrawDoc*	GetDocument() { return m_pDocument; }
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	CWnd*			m_pLastFocus;
	CStatusBar		m_wndStatusBar;
    CColourWindow	m_wndColour;
    CCharSetWindow	m_wndCharSet;
	CChatWindow		m_wndChat;
	CPreviewWindow	m_wndPreview;
	CUserListWindow m_wndUserList;
	CToolBar        m_wndToolBar;
	CPabloDrawDoc*	m_pDocument;
	CCanvasView*	m_pView;
	cMenu			m_menu;
	cCommandList	m_cl;

protected:

	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMove(int x, int y);
    afx_msg LRESULT OnUpdateColour(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnUpdateCharSet(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnAddMessage(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserJoined(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserParted(WPARAM wparam, LPARAM lparam);
	afx_msg void OnSwitchChatEdit();

	void DockControlBarLeftOf(CControlBar* Bar, CControlBar* LeftOf);
    void ActivateFrame(int nCmdShow);

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnActivate(UINT nState,CWnd* pWndOther,BOOL bMinimized);
	afx_msg void OnShowChatWindow();
	afx_msg void OnUpdateShowChatWindow(CCmdUI *pCmdUI);
	afx_msg void OnShowPreview();
	afx_msg void OnUpdateShowPreview(CCmdUI *pCmdUI);

	afx_msg void OnCanvasBreakconnection();
	afx_msg void OnCanvasConnecttoserver();
	afx_msg void OnCanvasStartserver();
	afx_msg void OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasStartserver(CCmdUI* pCmdUI);
	afx_msg void OnViewCharacterSet();
	afx_msg void OnUpdateViewCharacterSet(CCmdUI *pCmdUI);
	afx_msg void OnViewColourbar();
	afx_msg void OnUpdateViewColourbar(CCmdUI *pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);

	afx_msg void OnCycleBackground8();
	afx_msg void OnUpdateCycleBackground8(CCmdUI *pCmdUI);
	afx_msg void OnItpCompat();
	afx_msg void OnUpdateItpCompat(CCmdUI *pCmdUI);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg void OnFullscreenSwitch();
	afx_msg void OnUpdateFullscreenSwitch(CCmdUI *pCmdUI);
	afx_msg void OnViewMenubar();
	afx_msg void OnUpdateViewMenubar(CCmdUI *pCmdUI);
	afx_msg void OnUpdateInsert(CCmdUI *pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnViewToolbar();
	afx_msg void OnUpdateViewToolbar(CCmdUI *pCmdUI);
	BOOL CreateMenu(void);
};

