// PabloDraw.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "PabloDraw.h"

#include "MainFrm.h"
#include "PabloDrawDoc.h"
#include "canvasview.h"
#include "cFormat.h"
#include "afxwin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawApp

BEGIN_MESSAGE_MAP(CPabloDrawApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawApp construction

CPabloDrawApp::CPabloDrawApp()
{
    m_formatList.AddTail(new cFormatAnsi);
    m_formatList.AddTail(new cFormatBinary);
    m_formatList.AddTail(new cFormatAscii);
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPabloDrawApp object
CPabloDrawApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawApp initialization

BOOL CPabloDrawApp::InitInstance()
{
	InitCommonControls();

	if (!AfxSocketInit())
	{
		AfxMessageBox("Socket initialization failed!");
		return FALSE;
	}

	AfxEnableControlContainer();

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
    SetRegistryKey(_T("PabloDraw"));

	m_Options.LoadDefaults();
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	CPabloDrawDoc* pDoc = new CPabloDrawDoc();
	pDoc->OnNewDocument();
	CMainFrame* pMainFrame = new CMainFrame(pDoc);
	if (!pMainFrame->Create(NULL, _T("PabloDraw")))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
    if (!ProcessShellCommand(cmdInfo))
        return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();


	return TRUE;
}



CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	TCHAR tszFile[1024];
	::GetModuleFileName(NULL, tszFile, sizeof(tszFile));
	DWORD dwSize = GetFileVersionInfoSize(tszFile, 0);
	UCHAR* pBlock = new UCHAR[dwSize];
	GetFileVersionInfo(tszFile, NULL, dwSize, pBlock);

	UINT uiLen;

	VS_FIXEDFILEINFO* pffInfo;
	VerQueryValue(pBlock, _T("\\"), (LPVOID*)&pffInfo, &uiLen); 
	m_strVersion.Format(_T("%i.%i.%i"), HIWORD(pffInfo->dwFileVersionMS), LOWORD(pffInfo->dwFileVersionMS), HIWORD(pffInfo->dwFileVersionLS));
	m_strBuildNumber.Format(_T("%i"), LOWORD(pffInfo->dwFileVersionLS));
	delete [] pBlock;
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, ID_VERSION, m_strVersion);
	DDX_Text(pDX, ID_BUILD_NUMBER, m_strBuildNumber);
	DDX_Control(pDX, IDC_BUTTON_LINK, m_LinkButton);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_LINK, OnBnClickedButtonLink)
END_MESSAGE_MAP()

// App command to run the dialog
void CPabloDrawApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawApp message handlers


void CPabloDrawApp::OnFileOpen()
{
	CString strFilter = GetFormatString(FMT_LOAD);
    CFileDialog fd(TRUE, NULL, NULL, OFN_NOREADONLYRETURN | OFN_ENABLESIZING, strFilter);
    if (fd.DoModal() == IDOK)
    {
        CWinApp::OpenDocumentFile(fd.GetPathName());
    }

}

int CPabloDrawApp::ExitInstance()
{
	// TODO: Add your specialized code here and/or call the base class
	m_Options.SaveDefaults();
	if (m_pBuffer) delete m_pBuffer;
	return CWinApp::ExitInstance();
}


CString CPabloDrawApp::GetFormatString(fFormatMapType  formatType)
{
	CString str;
    CString strFilter;
	CString strAllSupported;
	POSITION pos = m_formatList.GetHeadPosition();
	while (pos)
	{
		cFormat* pFormat = m_formatList.GetNext(pos);
		POSITION posFormat = pFormat->GetFormatMapList()->GetHeadPosition();
		while (posFormat)
		{
			const sFormatMap& fm = pFormat->GetFormatMapList()->GetNext(posFormat);
			if (fm.type & formatType)
			{
				str.Format(_T("%s Files (*%s)|*%s|"), fm.strDescription, fm.strExtension, fm.strExtension);
				strFilter += str;
				if (!strAllSupported.IsEmpty()) strAllSupported += _T(";");
				strAllSupported += _T("*") + fm.strExtension;
			}
		}
	}
	if (formatType == FMT_SAVE)
	{
		CString strTemp = strFilter;
		strFilter.Format(_T("Auto|%s|%s"), strAllSupported, strTemp);
	}
	if (formatType == FMT_LOAD)
	{
		CString strTemp = strFilter;
		strFilter.Format(_T("All Known Types|%s|%s"), strAllSupported, strTemp);

		strFilter += _T("All Files (*.*)|*.*|");
	}
	strFilter += _T("|");
	return strFilter;
}

cFormat* CPabloDrawApp::GetFormat(LPCTSTR lpszPathName, fFormatMapType p_formatType)
{
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];

	_tsplitpath(lpszPathName, drive, dir, fname, ext);
	POSITION pos = m_formatList.GetHeadPosition();
	while (pos)
	{
		cFormat* pFormat = m_formatList.GetNext(pos);
		if (pFormat->IsProperFormat(ext, p_formatType))
		{
			return pFormat;
		}
	}
	return m_formatList.GetHead();
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnBnClickedButtonLink()
{
	ShellExecute(NULL, _T("open"), _T("http://pablodraw.sourceforge.net"), NULL,NULL, SW_SHOW);
}


void CPabloDrawApp::OnFileNew()
{
	CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
	pFrame->GetDocument()->OnNewDocument();
}

CDocument* CPabloDrawApp::OpenDocumentFile(LPCTSTR lpszFileName)
{
	CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
	pFrame->GetDocument()->OnOpenDocument(lpszFileName);
	return pFrame->GetDocument();
}
