#pragma once

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "cOptions.h"
#include "cFormat.h"
#include "cFormatAnsi.h"
#include "cFormatAscii.h"
#include "cFormatBinary.h"


#define WM_DOREALIZE   (WM_USER + 0)

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawApp:
// See PabloDraw.cpp for the implementation of this class
//

class CPabloDrawApp : public CWinApp
{
public:
    CPabloDrawApp();

    inline cOptions*	GetOptions() { return &m_Options; }
    inline cFormatList* GetFormatList() { return &m_formatList; }
	CString				GetFormatString(fFormatMapType formatType);
	cFormat*			GetFormat(LPCTSTR lpszPathName, fFormatMapType p_formatType);
	cCanvas*			GetBuffer() { return m_pBuffer; }
	void				SetBuffer(cCanvas* p_pCanvas)
							{
								if (m_pBuffer) delete m_pBuffer;
								m_pBuffer = p_pCanvas;
							}

protected:
    cOptions			m_Options;
    cFormatList			m_formatList;
    cCanvas*			m_pBuffer;


public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();

	// message map functions
	DECLARE_MESSAGE_MAP()
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpen();
	afx_msg void OnFileNew();
	virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
};


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	CString m_strVersion;
	CString m_strBuildNumber;
	CButton m_LinkButton;
	virtual BOOL OnInitDialog();
	afx_msg void OnBnClickedButtonLink();
};
