// ServingSocket.cpp: implementation of the CServingSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "ServingSocket.h"
#include "ListeningSocket.h"
#include "PabloDrawdoc.h"
#include "pablo_ver.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServingSocket::CServingSocket(CListeningSocket* pListenSocket)
{
    m_pListenSocket = pListenSocket;
	m_pFile = NULL;
	m_pThread = NULL;
	m_bUserJoined = FALSE;
}

CServingSocket::~CServingSocket()
{
	if (m_pFile != NULL) delete m_pFile;
}

BOOL CServingSocket::Init()
{
    CPabloDrawDoc* pDoc = (CPabloDrawDoc*)m_pListenSocket->m_pDoc;
    cPage* pPage = pDoc->GetCurrentPage();
	if (!pPage) return FALSE;
    cCanvas* pCanvas = pPage->GetCanvas();

//    CSingleLock slCrit(m_pCriticalSection);
	m_pFile = new cSocketFile(this, TRUE);
	
	cArchive_store(ar, m_pFile); 


	//CSingleLock slCrit(&m_pListenSocket->m_mutex, TRUE);

//	slCrit.Lock();

	//slCrit.Unlock();

    ar.Writeul(MT_INIT);
	ar.Writeul(PABLO_SOCKET_VERSION);
	ar.Writeul(_tcslen(PABLO_BUILD));
	ar.WriteString(PABLO_BUILD);
	ar.Writeul(pCanvas->GetSize().cx);
	ar.Writeul(pCanvas->GetSize().cy);
	CStringList sl;
	m_pListenSocket->GetAliasList(sl, this);
	ar.Writeul(sl.GetCount());
	POSITION pos = sl.GetHeadPosition();
	while (pos)
	{
		CString& strAlias = sl.GetNext(pos);
		ar.Writeul(strAlias.GetLength());
		ar.WriteString(strAlias);
	}

	ar.Flush();

    CRect rect = CRect(CPoint(0,0),CSize(pCanvas->GetSize().cx, pCanvas->FindEndY()+1));
	if (rect.bottom > 0)
    {
		cMemCanvas mc(rect.Size());
		mc.Set(rect.TopLeft(), pCanvas, CPoint(0,0), rect.Size());
		CClientSocket::SendPart(m_pFile, &mc, CRect(CPoint(0,0), rect.Size()), rect.TopLeft(), pDoc->GetApp()->GetOptions());
    }
	// send all the current users to the new client
	ar.Flush();
//	slCrit.Unlock();
	return TRUE;
}

void CServingSocket::OnClose(int nErrorCode)
{
	// send message to everyone else that this user has left
	CSingleLock sl(m_pCriticalSection, TRUE);
	//if (m_bUserJoined)
	{
		//if (m_pListenSocket) m_pListenSocket->RemoveSocket(m_pThread);
		CString str = m_strAlias;

		m_pListenSocket->Writeul(MT_USER_PART, this);
		m_pListenSocket->Writeul(nErrorCode, this);
		m_pListenSocket->Writeul(str.GetLength(), this); // length
		m_pListenSocket->Write((const void*)(LPCTSTR)str, str.GetLength(), this);
	}
	CSocket::OnClose(nErrorCode);
	if (m_pThread) m_pThread->PostThreadMessage(WM_USER_DISCONNECT, 0,0); //OnDisconnect(0, 0);
}

void CServingSocket::OnReceive(int nErrorCode)
{
	CSocket::OnReceive(nErrorCode);

#if 1
	//CSingleLock sl(&m_pListenSocket->m_mutex, TRUE);
	CSingleLock sl(m_pCriticalSection, TRUE);
	/*
	char buf[1024];
	int readbytes = 0;
	CMemFile mf;
	eMessageType mt;
	ULONG ul;					 

	if (m_pFile->Read(&ul, sizeof(ULONG)) != sizeof(ULONG)) return;
	mt = (eMessageType)ul;
	if (mt == MT_USER_JOIN)
	{
		if (m_pFile->Read(&ul, sizeof(ULONG)) != sizeof(ULONG)) return;
		CString str;
		if (m_pFile->Read((void*)str.GetBufferSetLength(ul), ul) != ul) return;
		m_strAlias = str;
		m_pListenSocket->Writeul(mt);
		m_pListenSocket->Writeul(ul);
		m_pListenSocket->Write(str.GetBuffer(), ul);
		return;
	}

	if (mt == MT_CLEARFILE) { m_pListenSocket->Writeul(mt, this); sl.Unlock(); return; }
	if (mt != MT_USER_JOIN) mf.Write(&mt, sizeof(ULONG));
	*/
	/*
	do
	{
		readbytes = m_pFile->Read(buf, sizeof(buf));
		//readbytes = ar.Read(buf, sizeof(buf));
		//if (readbytes > 0) m_pListenSocket->Write(buf, readbytes);
		if (readbytes > 0) mf.Write(buf, readbytes);
	}
	while (readbytes == sizeof(buf));

	mf.SeekToBegin();
	do
	{
		readbytes = mf.Read(buf, sizeof(buf));
		if (readbytes > 0) m_pListenSocket->Write(buf, readbytes);
	}
	while (readbytes > 0);
	mf.SeekToBegin();
	*/
	cArchive_load(ar, m_pFile);
	BOOL bUndoState;
	ULONG ulUndoCombine;
	CClientSocket::RecieveData(ar, m_pListenSocket->m_pDoc, bUndoState, ulUndoCombine, this);

#endif
#if 0
	ULONG ulCount;
	CString str;
    CPoint pt;
	eMessageType mt;
    CRect rect;
	cArchive_load(ar, m_pFile);
	
	do
	{
	    //CSingleLock sl(m_pCriticalSection, TRUE);
		mt = (eMessageType)ar.Readul();
        switch (mt)
        {
/*
        case MT_CLOSE:
            //OnClose(0); // the 1 tells the thread not to try sending a close message back.
		    if (m_pCriticalSection) m_pCriticalSection->Unlock();
			if (m_pThread) m_pThread->OnDisconnect(0, 0);
            return;  // we return, since this socket is now closed!
*/
		case MT_CLEARFILE:
            m_pListenSocket->Writeul(mt, this);
			break;
		case MT_CLEAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul()); // width
            m_pListenSocket->Writeul(ar.Readul()); // height
			break;
		case MT_DELETECOL:
		case MT_INSERTCOL:
		case MT_INSERTLINE:
        case MT_DELETELINE:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul()); // line/col to insert at
			break;
        case MT_DELETECHAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeuc(ar.Readuc()); // insert
            m_pListenSocket->Writeul(ar.Readul()); // x
            m_pListenSocket->Writeul(ar.Readul()); // y
            break;
        case MT_INSERTCHAR:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeuc(ar.Readuc()); // insert
            m_pListenSocket->Writeul(ar.Readul()); // x
            m_pListenSocket->Writeul(ar.Readul()); // y
            m_pListenSocket->Writeus(ar.Readus()); // value
            break;
		
		case MT_UNDO:
			{
				cPage* pPage = m_pListenSocket->GetDocument()->GetCurrentPage();
				CRectArray	arrRect;
				CPoint		ptCursor;
				pPage->Undo(arrRect, ptCursor, m_pListenSocket);
			}
			break;
		case MT_REDO:
			{
				cPage* pPage = m_pListenSocket->GetDocument()->GetCurrentPage();
				CRectArray	arrRect;
				CPoint		ptCursor;
				pPage->Redo(arrRect, ptCursor, m_pListenSocket);
			}
			break;
		case MT_UNDOCOMBINE:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->Writeul(ar.Readul());
			break;

		case MT_FILL_CHAR:
		case MT_FILL_ATTR:
		case MT_FILL_FORE:
		case MT_FILL_BACK:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->WriteRc(ar.ReadRc());
            m_pListenSocket->Writeuc(ar.Readuc());
			break;

		case MT_ERASE_RECT:
        case MT_DELETE_RECT:
            m_pListenSocket->Writeul(mt);
            m_pListenSocket->WriteRc(ar.ReadRc());
			break;

        case MT_SENDPART:
			{
				rect = ar.ReadRc();
				ULONG ulSize = ar.Readul();
				char* buf = new char[ulSize];
				ar.Read(buf, ulSize);


				m_pListenSocket->Writeul(mt);
				m_pListenSocket->WriteRc(rect);
				m_pListenSocket->Writeul(ulSize);

				m_pListenSocket->Write(buf, ulSize);

				delete [] buf;


/*
				sCanvasElement ce;
				cMemCanvas mc(rect.Size());
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					for (pt.x=0; pt.x<rect.Width(); pt.x++)
					{
						ce.value = ar.Readus();
						mc.Set(pt, ce);
					}
				}

				// write everything after everything is read
				m_pListenSocket->Writeul(mt);
				m_pListenSocket->WriteRc(rect);

				sCanvasElement* pBuf = new sCanvasElement[rect.Width()];
				pt.x = 0;
				for (pt.y=0; pt.y<rect.Height(); pt.y++)
				{
					mc.GetLine(pt, pBuf);
					m_pListenSocket->Write(pBuf, rect.Width()*sizeof(sCanvasElement));
				}
				delete [] pBuf;
				*/
			}
            break;

		case MT_USER_JOIN:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
			m_strAlias = str;
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);

			m_bUserJoined = TRUE;
			break;

		case MT_USER_PART:
			{
			ULONG ulCount2 = ar.Readul();
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount2); // length
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);
			break;
			}

		case MT_MESSAGE:
			ulCount = ar.Readul();
			ar.Read((void*)str.GetBufferSetLength(ulCount), ulCount);
            m_pListenSocket->Writeul(mt);
			m_pListenSocket->Writeul(ulCount); // length
			m_pListenSocket->Write((const void*)(LPCTSTR)str, ulCount);
			break;
        }
    }
    while (!ar.IsBufferEmpty());
#endif	
    //m_pListenSocket->FlushAll();
}

