#pragma once


#include "ServingSocket.h"
#include "ListeningSocket.h"

#define WM_USER_DISCONNECT      (WM_USER +  106)

/////////////////////////////////////////////////////////////////////////////
// CServingSocketThread thread

class CServingSocketThread : public CWinThread
{
	friend CListeningSocket;
	DECLARE_DYNCREATE(CServingSocketThread)
protected:
	CServingSocketThread();           // protected constructor used by dynamic creation

// Attributes
public:

    BOOL Initialize(CServingSocketThread* p_pThread, CListeningSocket* p_pListeningSocket, SOCKET p_hsocket);
	CServingSocket* GetSocket() { return m_pSocket; }

	// Used to pass the socket handle from the main thread to this thread.
	SOCKET m_hSocket;

// Operations
public:

// Overrides
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();

	afx_msg void OnDisconnect(WPARAM wParam, LPARAM lParam);

	CEvent m_eventStarted;
	CEvent m_eventEnded;
    CServingSocket* m_pSocket;
	CListeningSocket* m_pListeningSocket;

// Implementation
protected:
	virtual ~CServingSocketThread();
	afx_msg void OnFlush(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSendBuffer(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSendULong(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSendUShort(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSendUChar(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()



	
	// CSocket derived class that handles the connection.
	CServingSocketThread* m_pServingSocketThread;

};

