
#include "stdafx.h"
#include "cfont.h"
#include "carchive.h"

cFont::cFont(CSize p_size, int p_iNumChars)
{
    m_pData = NULL;
    Resize(p_size, p_iNumChars);
}

cFont::~cFont()
{
    for (int iCharLines=0; iCharLines<m_iNumChars*m_iCharSize; iCharLines++)
	{
		delete [] m_pData[iCharLines];
	}
	delete [] m_pData;
}


BOOL cFont::Resize(CSize p_size, int p_iNumChars)
{
    ASSERT(p_iNumChars > 0);
    BOOL** pOldData = m_pData;
    int iOldNumChars = m_iNumChars;
    int iOldCharSize = m_iCharSize;
    CSize sizeOld = m_size;
    int iCharLines;

    m_iNumChars = p_iNumChars;
    m_size = p_size;
    m_iCharWidth = ((m_size.cx + 7) / 8);
    m_iCharSize = m_iCharWidth*m_size.cy;
    m_pData = new BOOL*[m_iCharSize * m_iNumChars];

    for (iCharLines=0; iCharLines<m_iNumChars*m_iCharSize; iCharLines++)
	{
		m_pData[iCharLines] = new BOOL[m_size.cx];
	}


    for (int iChars=0; iChars<m_iNumChars; iChars++)
	{
		for (int iCharY=0; iCharY<m_size.cy; iCharY++)
        {
            for (int iCharX=0; iCharX<m_size.cx; iCharX++)
            {
                BOOL bCurrent = FALSE;
                if (pOldData && (iCharX < sizeOld.cx) && (iCharY < sizeOld.cy)) bCurrent = (pOldData[(iChars*iOldCharSize)+iCharY][iCharX]);
                if (pOldData && iCharX >= sizeOld.cx && sizeOld.cx < m_size.cx && (iCharY < sizeOld.cy) && iChars >= 192 && iChars <= 223)
                {
                    bCurrent = (pOldData[(iChars*iOldCharSize)+iCharY][sizeOld.cx-1]);
                }
                m_pData[(iChars*m_iCharSize)+iCharY][iCharX] = bCurrent;
            }
        }

	}


    if (pOldData != NULL)
	{
		for (iCharLines=0; iCharLines<iOldNumChars*iOldCharSize; iCharLines++)
		{
			delete [] pOldData[iCharLines];
		}
		delete [] pOldData;
	}

    return TRUE;
}


BOOL cFont::Scale(CSize p_size, int p_iNumChars)
{
    ASSERT(p_iNumChars > 0);
    BOOL** pOldData = m_pData;
    int iOldNumChars = m_iNumChars;
    int iOldCharSize = m_iCharSize;
    CSize sizeOld = m_size;
    int iCharLines;

    m_iNumChars = p_iNumChars;
    m_size = p_size;
    m_iCharWidth = ((m_size.cx + 7) / 8);
    m_iCharSize = m_iCharWidth*m_size.cy;
    m_pData = new BOOL*[m_iCharSize * m_iNumChars];

    for (iCharLines=0; iCharLines<m_iNumChars*m_iCharSize; iCharLines++)
	{
		m_pData[iCharLines] = new BOOL[m_size.cx];
	}


    for (int iChars=0; iChars<m_iNumChars; iChars++)
	{
		for (int iCharY=0; iCharY<m_size.cy; iCharY++)
        {
            for (int iCharX=0; iCharX<m_size.cx; iCharX++)
            {
				BOOL bCurrent = FALSE;
				if (sizeOld.cx > m_size.cx && sizeOld.cy > m_size.cy)
				{
					if (iCharX < sizeOld.cx && (iCharY < sizeOld.cy) && iChars >= 176 && iChars <= 178)
					{
						bCurrent = (pOldData[(iChars*iOldCharSize)+iCharY][iCharX]);
					}
					else 
					{
						int iPixelCount = 0;
						int iTotalCount = 0;
						int iSrcCharYStart = iCharY*sizeOld.cy/m_size.cy;
						int iSrcCharYEnd = (iCharY+1)*sizeOld.cy/m_size.cy;
						if (iSrcCharYEnd >= sizeOld.cy) iSrcCharYEnd = sizeOld.cy-1;


						int iSrcCharXStart = iCharX*sizeOld.cx/m_size.cx;
						int iSrcCharXEnd = (iCharX+1)*sizeOld.cx/m_size.cx;
						if (iSrcCharXEnd >= sizeOld.cx) iSrcCharXEnd = sizeOld.cx-1;

						// now, go through the source font to find what we need for this pixel
						for (int iSrcCharY=iSrcCharYStart; iSrcCharY<iSrcCharYEnd; iSrcCharY++)
						{
							for (int iSrcCharX=iSrcCharXStart; iSrcCharX<iSrcCharXEnd; iSrcCharX++)
							{
								if (pOldData[(iChars*iOldCharSize)+iSrcCharY][iSrcCharX]) iPixelCount++;
								iTotalCount++;
							}
						}
						bCurrent = (iPixelCount > 0 && (iPixelCount >= (iTotalCount/2)));
					}
				}
				else
				{
					int iSrcCharY = iCharY*sizeOld.cy/m_size.cy;
					int iSrcCharX = iCharX*sizeOld.cx/m_size.cx;
					if (iSrcCharY >= sizeOld.cy) iSrcCharY = sizeOld.cy-1;
					if (iSrcCharX >= sizeOld.cx) iSrcCharX = sizeOld.cx-1;
					bCurrent = pOldData[(iChars*iOldCharSize)+iSrcCharY][iSrcCharX];

				}
				m_pData[(iChars*m_iCharSize)+iCharY][iCharX] = bCurrent;
            }
        }

	}


    if (pOldData != NULL)
	{
		for (iCharLines=0; iCharLines<iOldNumChars*iOldCharSize; iCharLines++)
		{
			delete [] pOldData[iCharLines];
		}
		delete [] pOldData;
	}

    return TRUE;
}


BOOL* cFont::GetFontLine(int p_iChar, int p_iLine)
{
    return m_pData[(p_iChar*m_iCharSize)+p_iLine];
}

BOOL cFont::GetPoint(int p_iChar, CPoint p_point)
{
	ASSERT(p_iChar >= 0 && p_iChar <= m_iNumChars);
    return (m_pData[(p_iChar*m_iCharSize)+p_point.y][p_point.x]) != 0;
}


BOOL cFont::Load(CFile& file, int p_iMaxRows)
{
#ifdef USE_MFC_ARCHIVE
	cArchive ar(&file, cArchive::load);
#else
	cArchive ar(&file);
#endif
    CSize sizeNew;
    sizeNew.cx = ar.Readus(); 
    sizeNew.cy = ar.Readus();
    int iNewChars = ar.Readus();
    
    if (!Resize(sizeNew, iNewChars)) return FALSE;

    UCHAR* pData = new UCHAR[m_iNumChars*m_iCharSize*m_iCharWidth];
    
    if (!ar.Read(pData,m_iNumChars*m_iCharSize)) return FALSE;
	
    for (int iCharLines=0; iCharLines<m_iNumChars*m_iCharSize; iCharLines++)
	{
		for (int iChar=0; iChar<8; iChar++)
		{
			m_pData[iCharLines][iChar] = ((pData[iCharLines] & (128 >> iChar)) != 0);
		}
	}
	delete [] pData;
	return TRUE;
}


void cFont::Set(const cFont& p_font)
{
	Resize(p_font.GetSize(), p_font.GetNumChars());
    for (int iCharLines=0; iCharLines<m_iNumChars*m_iCharSize; iCharLines++)
	{
		for (int iChar=0; iChar<m_size.cx; iChar++)
		{
			m_pData[iCharLines][iChar] = p_font.m_pData[iCharLines][iChar];
		}
	}
}
