

#include "stdafx.h"
#include "cformatansi.h"


cFormatAnsi::cFormatAnsi() :
    cFormat("Ansi", FORMAT_SUPPORT_DATA)
{
	AddFormatMap(FMT_LOAD | FMT_SAVE, _T("Ansi"), _T(".ans"));
	AddFormatMap(FMT_LOAD, _T("Ascii"), _T(".asc"));
	AddFormatMap(FMT_LOAD, _T("Text"), _T(".txt"));
}

cFormatAnsi::~cFormatAnsi()
{
}

const int OUTPUT_LENGTH_UNLIMITED = -1;


const LPCSTR ansifore[] = { "30", "34", "32", "36", "31", "35", "33", "37" };
const LPCSTR ansiback[] = { "40", "44", "42", "46", "41", "45", "43", "47" };


int spacecount;
int lineslength;
int xposition;


int bold;
int lback;
int lfore;
int lbold;
int lblink;
int blink;
int lastback;
int lastfore;
int currfore;
int currback;
char currchar;
int currattr;

int x;
int y;


BOOL esc_colour;

void cFormatAnsi::WriteToAnsi(cArchive& ar, LPCSTR p_szString, BOOL p_bCompress)
{
    int d;
    int e;
    CString strTemp;

    if (*p_szString == ' ' && p_bCompress) 
    {
        spacecount++;
    }
    else
    {
        if (spacecount>0)
        {
            d = spacecount;
            spacecount = 0;
            strTemp.Empty();
            if (d>4)
            {
                strTemp.Format("\x1b[%iC", d);
            }
            else if (d>0)
            {
                for (e = 0; e<d; e++) strTemp += " ";
            }
            if ((lineslength != OUTPUT_LENGTH_UNLIMITED) && 
                (xposition+strTemp.GetLength()+5 >= lineslength))
            {
                if (lback>0) ar.WriteString("\x1b[40m");
                strTemp = "\r\n\x1b[A";
                ar.WriteString(strTemp);
                xposition += strTemp.GetLength();
                if (x>m_rect.left)
                {
                    strTemp.Format("\x1b[%iC", x);
                    ar.WriteString(strTemp);
                    xposition += strTemp.GetLength();
                }
                if (lback>0)
                {
                    if (esc_colour)
                    {
                        bold = lbold;
                        blink = lblink;
                        lastback = blink*8;
                        lastfore = lfore;
                        return;
                    }
                    else
                    {
                        strTemp.Format("\x1b[%im", ansiback[lback % 8]);
                        ar.WriteString(strTemp);
                        xposition += strTemp.GetLength();
                    }
                }

            }
            else
            {
                WriteToAnsi(ar, strTemp, FALSE);
            }
        }


        if (strcmp(p_szString, "\r\n") == 0)
        {
            xposition = 0;
            spacecount = 0;
        }
        else
        {
            if ((lineslength != OUTPUT_LENGTH_UNLIMITED) &&
                ( (xposition+ (int)strlen(p_szString)) >= lineslength))
            {
                if (lback>0) ar.WriteString("\x1b[40m");
                ar.WriteString("\r\n");
                strTemp = "\x1b[A";
                ar.WriteString(strTemp);
                xposition += strTemp.GetLength();
                if (x>m_rect.left)
                {
                    strTemp.Format("\x1b[%iC", x);
                    ar.WriteString(strTemp);
                    xposition += strTemp.GetLength();
                }
                if (lback>0)
                {
                    if (esc_colour)
                    {
                        bold = lbold;
                        blink = lblink;
                        lastback = blink*8;
                        lastfore = lfore;
                        return;
                    }
                    else
                    {
                        strTemp.Format("\x1b[%im", ansiback[lback % 8]);
                        ar.WriteString(strTemp);
                        xposition += strTemp.GetLength();
                    }
                }
            }
            xposition += strlen(p_szString);
        }
		if (*p_szString == 0) // string is empty, write a zero byte
			ar.Writec(0);
		else
			ar.WriteString(p_szString);
    }
    esc_colour = FALSE;

}

void cFormatAnsi::SetFlags(CString& strCol)
{
    if ((blink == 0||blink==-1) && (currback > 7))
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += "5";
        blink = 1;
        lastback |= 8;

    }
    else if ((blink == 1||blink==-1) && (currback <=7))
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += "0";
        blink = 0; lastback = 0; lastfore = 7;
        if (currfore > 7)
        {
            strCol += ";1";
            bold = 1;
        }
        else bold = 0;
    }

    if ((bold == 0||bold==-1) && (currfore > 7))
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += "1";
        bold = 1;
        lastfore |= 8;
    }
    else if ((bold == 1||bold==-1) && (currfore <=7))
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += "0";
        bold = 0;
        lastback = 0;
        lastfore = 7;
        if (blink == 1) strCol += ";5";
    }
}

void cFormatAnsi::SetColours(CString& strCol)
{
    if (lastback != currback)
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += ansiback[currback & 0x07];
        lastback = currback;
    }
    if (lastfore != currfore)
    {
        if (!esc_colour) { strCol += "\x1b["; esc_colour = TRUE; } else strCol += ";";
        strCol += ansifore[currfore & 0x07];
        lastfore = currfore;
    }
}

void cFormatAnsi::WriteColour(cArchive& ar)
{
    lback = lastback; lfore = lastfore;
    lbold = bold; lblink = blink;
    CString strCol;
    do
    {
        esc_colour = FALSE;
        strCol.Empty();
        SetFlags(strCol);
        SetColours(strCol);
        strCol += "m";
        if (esc_colour) WriteToAnsi(ar, strCol, FALSE);
    } while (esc_colour);
    lback = lastback; lfore = lastfore;
    lbold = bold; lblink = blink;
}

BOOL cFormatAnsi::Save(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
	CRect rectSave;
	if (!p_pPageList->IsEmpty())
    {
	    cPage* pPage = p_pPageList->GetHead();
        cCanvas* pCanvas = pPage->GetCanvas();

		return Save(p_pFile, pCanvas, CRect(0,0,0,0), p_pOptions);
	}
	return FALSE;
}

BOOL cFormatAnsi::Save(CFile* p_pFile, cCanvas* p_pCanvas, CRect p_rect, cOptions* p_pOptions)
{
	cArchive_store(ar, p_pFile);

    x = 0;
    spacecount = 0;
    lineslength = -1;
    xposition = 0;
    currfore = 7; currback = 0;
    lastback = -1; lastfore = -1;
    bold = -1;
    blink = -1;
    sCanvasElement curelem;
	m_rect = p_rect;
    WriteColour(ar);

	if (p_rect.bottom == 0) p_rect.bottom = p_pCanvas->FindEndY()+1;
	if (p_rect.right == 0) p_rect.right = p_pCanvas->GetSize().cx;
	for (y=p_rect.top; y<p_rect.bottom; y++)
    {
		int iXEnd = p_pCanvas->FindEndX(y, p_rect.left, p_rect.right);

		for (x=p_rect.left; x<=iXEnd; x++)
        {
            curelem = p_pCanvas->Get(CPoint(x,y));
            currchar = curelem.character;
            currattr = curelem.attribute;
            currback = currattr >> 4; 
            currfore = currattr & 0x0f;
            
            WriteColour(ar);
//			if (currchar == 0) currchar = 32;

            WriteToAnsi(ar, CString(currchar), (currback == 0));
        }

        if (iXEnd < p_rect.right-1)
        {
            if (lastback > 0)
            {
                WriteToAnsi(ar, "\x1b[0m", FALSE);
                lastfore = 7; 
                lastback = 0;
                blink = 0;
                bold = 0;
            }
            WriteToAnsi(ar, "\r\n", FALSE);
        }
    }

    ar.Flush();
    return TRUE;
}

int cFormatAnsi::NextLine()
{
    m_ptCur.y++;

    if (m_ptCur.y > m_rect.bottom-1)
    {
        m_ptCur.y = m_rect.bottom-1;
        return -1;
    }
    //m_pCanvas->SetLine(CPoint(m_rect.left,m_ptCur.y), 7, 32, m_rect.Width()); // clear line

    return 0;
}

int cFormatAnsi::PrintRaw(UCHAR curbyte, UCHAR curcol)
{
    if (m_ptCur.x>=m_rect.left && m_ptCur.x<m_rect.right)
    {
        m_pCanvas->Set(m_ptCur, curcol, curbyte);
    }
    m_ptCur.x++;
//    if (op.loadwrap=OP_ON) && (x>=width)
    if (m_ptCur.x > m_rect.right-1)
    {
      if (NextLine() != 0) return -1;
      m_ptCur.x = m_rect.left;
    }
    return 0;
}

void cFormatAnsi::FindParam(LPCTSTR p_tszString, CParamArray& p)
{
    CString str = p_tszString;
    int pcount = 0;
    int i;

    if (str.GetLength() > 1)
    {
        while (str.GetLength()>0)
        {
            i = 0;
            CString strCurrent;
            while (i < str.GetLength())
            {
                if (str[i] >= '0' && str[i] <= '9')
                {
                    strCurrent += str[i];
                    i++;
                }
                else
                {
                    i++;
                    break;
                }
            }
            str.Delete(0,i);
            p.SetAtGrow(pcount, strCurrent);
            pcount++;
        }
    }
}

BOOL cFormatAnsi::Load(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
    cPage* pPage;
	if (p_pPageList->IsEmpty())
	{
		pPage = new cPage(p_pOptions);
		p_pPageList->AddTail(pPage);
	}
	else
	{
		pPage = p_pPageList->GetHead();
	}
    cCanvas* pCanvas = pPage->GetCanvas();
	pCanvas->Resize(CSize(80, pCanvas->GetSize().cy));

	return Load(p_pFile, pPage->GetCanvas(), CRect(0,0,0,0), p_pOptions);
}

BOOL cFormatAnsi::Load(CFile* p_pFile, cCanvas* p_pCanvas, CRect p_rect, cOptions* p_pOptions)
{
//    int             width;
    CPoint          ptSave;
    UCHAR           fgcolour, bgcolour, fgblink, fgbold, fgreverse;
    BOOL            bDrawChar;
    UCHAR           ansiMode;
    CStringArray    params;
    CString         str;
    BOOL            bDone = FALSE;
	cArchive_load(ar, p_pFile);
    CHAR            ch;
    int             i;
    int             count;

    fgreverse =0;
    fgbold =0;      // 0 or 8
    fgblink =0;     // 0 or 128
    fgcolour =7;
    bgcolour =0;
    ansiMode =0;

    if (p_rect.bottom == 0) p_rect.bottom = p_pCanvas->GetSize().cy;
    if (p_rect.right == 0) p_rect.right = p_pCanvas->GetSize().cx;
	m_rect = p_rect;

    ptSave = p_rect.TopLeft();
	m_ptCur = p_rect.TopLeft();

    m_pCanvas = p_pCanvas;

    m_pCanvas->SetLine(p_rect.TopLeft(), 7, 32, p_rect.Width()); // clear line
    
    while (!bDone)
    {
        bDrawChar = TRUE;
        ch = ar.Readuc();
        switch (ansiMode)
        {
        case 0:
            if (ch == 27)
            {
                ansiMode = 1;
                bDrawChar = FALSE;
            }
            break;
        case 1:
            if (ch == 91)
            {
                ansiMode = 2;
                bDrawChar = FALSE;
            }
            else
            {
                if (PrintRaw(27, (fgcolour | fgbold)+((bgcolour << 4) | fgblink)) == -1) bDone = TRUE;
                bDrawChar = TRUE;
                ansiMode = 0;
            }
            break;
        case 2:
            str = ch;
            if ((ch >= '0') && (ch <= '9') || (ch == ';'))
            {
                BOOL bDone = FALSE;
                while (!bDone && !ar.IsEOF())
                {
                    ch = ar.Readuc();
                    str += ch;
                    if (toupper(ch) >= 'A' && toupper(ch) <= 'Z') bDone = TRUE;
                }
            }
            CParamArray params;
            FindParam(str, params);
            switch (ch)
            {
            case 'A':  // move cursor up
                if (params.GetSize() > 0)
                {
                    i = _ttoi(params[0]);
                    if (i == 0) i = 1;
                }
                else i = 1;
                m_ptCur.y -= i;
                if (m_ptCur.y < p_rect.top) m_ptCur.y = p_rect.top;
                break;

            case 'B':  // move cursor down
                if (params.GetSize() > 0)
                {
                    i = _ttoi(params[0]);
                    if (i == 0) i = 1;
                }
                else i = 1;
                m_ptCur.y += i;
				if (m_ptCur.y > p_rect.bottom-1) m_ptCur.y = p_rect.bottom-1;
                break;

            case 'C':  // move cursor right
                if (params.GetSize() > 0)
                {
                    i = _ttoi(params[0]);
                    if (i == 0) i = 1;
                }
                else i = 1;
                m_ptCur.x += i;
                if (m_ptCur.x > p_rect.right-1) m_ptCur.x = p_rect.right-1;
                break;
                
            case 'D':  // move cursor left
                if (params.GetSize() > 0)
                {
                    i = _ttoi(params[0]);
                    if (i == 0) i = 1;
                }
                else i = 1;
                m_ptCur.x -= i;
                if (m_ptCur.x < p_rect.left) m_ptCur.x = p_rect.left;
                break;

            case 'H':
            case 'f':
                if (params.GetSize() > 0)
                {
                    i = _ttoi(params[0]);
                    if (i > 0) m_ptCur.y = i-1+p_rect.top; else m_ptCur.y = p_rect.top;
                }
                else m_ptCur.y = p_rect.top;

                if (params.GetSize() > 1)
                {
                    i = _ttoi(params[1]);
                    if (i > 0) m_ptCur.x = i-1+p_rect.left; else m_ptCur.x = p_rect.left;
                }
                else m_ptCur.x = p_rect.left;

                if (m_ptCur.y > p_rect.bottom-1) m_ptCur.y = p_rect.bottom-1;
                if (m_ptCur.y < p_rect.top) m_ptCur.y = p_rect.top;
                if (m_ptCur.x > p_rect.right-1) m_ptCur.x = p_rect.right-1;
                if (m_ptCur.x < p_rect.left) m_ptCur.x = p_rect.left;
                break;

            case 'J':
                if (params.GetSize() > 0)
                {
                    fgcolour = 7;
                    bgcolour = 0;
                    fgblink = 0;
                    m_pCanvas->Fill((fgcolour | fgbold)+((bgcolour << 4) | fgblink), ' ', p_rect);
                    m_ptCur.x = p_rect.left;
                    m_ptCur.y = p_rect.top;
                }
                break;

            case 'm':
                if (params.GetSize() == 0)
                {
                    fgcolour = 7;
                    bgcolour = 0;
                    fgblink = 0;
                    fgbold = 0;
                    fgreverse = 0;
                }
                for (count = 0; count<params.GetSize(); count++)
                {
                    int j;
                    i = _ttoi(params[count]);

                    switch (i)
                    {
                    case 0:
                        if (params[count].GetAt(0) == '0')
                        {
                            fgcolour = 7;
                            bgcolour = 0;
                            fgblink = 0;
                            fgbold = 0;
                            fgreverse = 0;
                        }
                        break;
                    
                    case 1: fgbold = 8; break;
                    case 2: fgbold = 0; break;
                    case 5: fgblink = 128; break;
                    case 7:
                        j = fgcolour;
                        fgcolour = bgcolour;
                        bgcolour = (UCHAR)j;
                        fgreverse = 1;
                        break;
                    case 22: fgbold = 0; break;
                    case 25: fgblink = 0; break;
                    case 27:
                        j = fgcolour;
                        fgcolour = bgcolour;
                        bgcolour = (UCHAR)j;
                        fgreverse = 0;
                        break;
                    case 30: fgcolour=0; break;
                    case 31: fgcolour=4; break;
                    case 32: fgcolour=2; break;
                    case 33: fgcolour=6; break;
                    case 34: fgcolour=1; break;
                    case 35: fgcolour=5; break;
                    case 36: fgcolour=3; break;
                    case 37: fgcolour=7; break;
                    case 40: bgcolour=0; break;
                    case 41: bgcolour=4; break;
                    case 42: bgcolour=2; break;
                    case 43: bgcolour=6; break;
                    case 44: bgcolour=1; break;
                    case 45: bgcolour=5; break;
                    case 46: bgcolour=3; break;
                    case 47: bgcolour=7; break;
                    }
                }

                break;
            case 'K':
                m_pCanvas->SetLine(m_ptCur, 7, 32, p_rect.Width()-m_ptCur.x+p_rect.left);
                break;
            case 's':
                ptSave = m_ptCur;
                break;

            case 'u':
                m_ptCur = ptSave;
                break;
            }

            bDrawChar = FALSE;
            ansiMode = 0;
            break;
        }
        if (bDrawChar && ansiMode == 0)
        {
            switch (ch)
            {
            case 10:
                m_ptCur.y++;
                if (m_ptCur.y > p_rect.bottom-1)
                {
                    m_ptCur.y = p_rect.bottom-1;
					bDone = TRUE;
                } 
				else
				{
//					m_pCanvas->SetLine(CPoint(p_rect.left,m_ptCur.y), 7, 32, p_rect.Width()); // clear line
				}
                m_ptCur.x = p_rect.left;
                break;
            case 13:
				// restore X in linefeed so's to support *nix type files
                break;

            case 26:
                break;

            default:
                if (PrintRaw(ch, (fgcolour | fgbold)+((bgcolour << 4) | fgblink)) == -1) bDone = TRUE;
                break;
            }

        }
        if (ar.IsEOF()) break;
    }
    return TRUE;
}

