															  

#include "stdafx.h"
#include "cFormatAscii.h"


cFormatAscii::cFormatAscii() :
    cFormat("Ansi", FORMAT_SUPPORT_DATA)
{
	AddFormatMap(FMT_SAVE, _T("Ascii"), _T(".asc"));
	AddFormatMap(FMT_SAVE, _T("Text"), _T(".txt"));
}

cFormatAscii::~cFormatAscii()
{
}

BOOL cFormatAscii::Load(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
	// loading not implemented cuz we always load thru ansi loader
	return FALSE;
}


BOOL cFormatAscii::Save(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
#ifdef USE_MFC_ARCHIVE
	cArchive        ar(p_pFile, cArchive::store);
#else
	cArchive		ar(p_pFile);
#endif

    int x;
	int y;
	sCanvasElement curelem;

    if (!p_pPageList->IsEmpty())
    {
	    cPage* pPage = p_pPageList->GetHead();
        cCanvas* pCanvas = pPage->GetCanvas();

        int iYEnd = pCanvas->FindEndY();
        for (y=0; y<=iYEnd; y++)
        {
            int iXEnd = pCanvas->FindEndX(y);
            for (x=0; x<=iXEnd; x++)
            {
                curelem = pCanvas->Get(CPoint(x,y));
				ar.Writeuc(curelem.character);
            }

            if (iXEnd < pCanvas->GetSize().cx-1)
            {
                ar.WriteString(_T("\r\n"));
            }
        }
    }

    ar.Flush();
    return TRUE;
}
