// cFormatBinary.cpp: implementation of the cFormatBinary class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PabloDraw.h"
#include "cFormatBinary.h"
#include "BinaryWidthDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cFormatBinary::cFormatBinary() :
    cFormat("Binary", FORMAT_SUPPORT_DATA)
{
	AddFormatMap(FMT_LOAD | FMT_SAVE, _T("Binary"), _T(".bin"));
}

cFormatBinary::~cFormatBinary()
{

}

BOOL cFormatBinary::Save(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
#ifdef USE_MFC_ARCHIVE
	cArchive        ar(p_pFile, cArchive::store);
#else
	cArchive        ar(p_pFile); //, cArchive::store);
#endif
    CPoint          pt;
    sCanvasElement  elem;
    cPage*          pPage = p_pPageList->GetHead();
    cCanvas*        pCanvas = pPage->GetCanvas();

    if (!pPage || !pCanvas) return FALSE;

	int iEndY = pCanvas->FindEndY();
	for (pt.y = 0; pt.y<=iEndY; pt.y++)
    {
        for (pt.x = 0; pt.x<pCanvas->GetSize().cx; pt.x++)
        {
            elem = pCanvas->Get(pt);
            ar.Writeuc(elem.character);
            ar.Writeuc(elem.attribute);
        }
    }
    return TRUE;
}

BOOL cFormatBinary::Load(CFile* p_pFile, tPageList* p_pPageList, cOptions* p_pOptions)
{
#ifdef USE_MFC_ARCHIVE
	cArchive        ar(p_pFile, cArchive::load);
#else
	cArchive        ar(p_pFile); //, cArchive::load);
#endif
    static LONG     lWidth = 80;
    sCanvasElement  elem;
    BOOL    bDone = FALSE;
    CPoint  pt;

    if (p_pOptions->GetDefaultBinaryWidth() == OP_ASK)
    {
        CBinaryWidthDlg dlgBinWidth;

        dlgBinWidth.m_lBinWidth = lWidth;

        if (dlgBinWidth.DoModal() == IDOK)
        {
            lWidth = dlgBinWidth.m_lBinWidth;
            p_pOptions->SetDefaultBinaryWidth((dlgBinWidth.m_bSetDefault) ? lWidth : OP_ASK);
        }
    }
    else
    {
        lWidth = p_pOptions->GetDefaultBinaryWidth();
    }

    cPage* pPage;
	if (p_pPageList->IsEmpty())
	{
		pPage = new cPage(p_pOptions);
		p_pPageList->AddTail(pPage);
	}
	else
	{
		pPage = p_pPageList->GetHead();
	}

    cCanvas* pCanvas = pPage->GetCanvas();
	pCanvas->Resize(CSize(lWidth, pCanvas->GetSize().cy));
    pt = CPoint(0,0);
    while (!ar.IsEOF())
    {
        elem.character = ar.Readuc();
        elem.attribute = ar.Readuc();
        if (pt.x<pCanvas->GetSize().cx)
            pCanvas->Set(pt,elem);
        pt.x++;

        if (pt.x>=lWidth)
        {
            pt.x = 0;
            pt.y++;
            if (pt.y>=pCanvas->GetSize().cy)
            {
                break;
            }
        }
    }

    return TRUE;
}
