
#ifndef __CPAGE_H__
#define __CPAGE_H__

#include "cCanvas.h"
#include "cFont.h"
#include "cPalette.h"
#include "cOptions.h"
#include "cUndo.h"

class cPage
{
public:
    cPage(cOptions* p_pOptions, CSize p_size = CSize(0,0), cFont* p_pFont = NULL, cPalette* p_pPalette = NULL);
    virtual ~cPage();

    inline cCanvas*     GetCanvas() { return m_pCanvas; }
    inline cFont*       GetFont() { return m_pFont; }
    inline cPalette*    GetPalette() { return m_pPalette; }

    BOOL SetFont8x8();
    BOOL SetFont8x16();
    BOOL SetFontAmiga();

	BOOL CanUndo() { return (m_posUndo != NULL); }
	BOOL CanRedo() { return m_posUndo != m_listUndo.GetTailPosition() && !m_listUndo.IsEmpty(); }
	void SaveCanvas(CRect p_rect, CPoint p_ptCursor, eUndoType p_UndoType = UT_BLOCK, BOOL p_bNewLevel = TRUE);

	BOOL IsAmigaFont() { return m_bIsAmigaFont; }

	void UpdateUndoBuffer(CPoint p_ptCursor, eUndoType p_enUndoType);
	void Undo(CRectArray& p_arrRect, CPoint& p_ptCursor, CListeningSocket* p_pSocket = NULL);
	void Redo(CRectArray& p_arrRect, CPoint& p_ptCursor, CListeningSocket* p_pSocket = NULL);
protected:
	cUndoList	m_listUndo;
	POSITION	m_posUndo;
	cCanvas*    m_pCanvas;
    cFont*      m_pFont;
    cPalette*   m_pPalette;
	BOOL		m_bIsAmigaFont;

	BOOL		m_bUndoing;
};


typedef CList<cPage*,cPage*> tPageList;


#endif