
#ifndef __CPALETTE_H__
#define __CPALETTE_H__

struct sPalette
{
    UCHAR red;
    UCHAR green;
    UCHAR blue;
};

class cPalette
{
public:
    cPalette(int p_iNumCol = 16);
    virtual ~cPalette();

    BOOL Resize(int p_iNumCol);

    void SetSystemDefault();
    
    BOOL Load(CFile& file, int p_iMaxCol = 0);

    PALETTEENTRY GetPaletteEntry(int p_iCol);
    RGBQUAD      GetRGBQuad(int p_iCol);
    inline COLORREF GetCol(int p_iCol);
    inline int GetNumCol() const { return m_iNumCol; }

private:
    sPalette*   m_pData;
    int         m_iNumCol;
};

inline COLORREF cPalette::GetCol(int p_iCol)
{
    ASSERT(p_iCol < m_iNumCol);
    sPalette& pal = m_pData[p_iCol];
    return RGB(pal.red,pal.green,pal.blue);
}


#endif