#pragma once

#include "cCanvas.h"
#include "ListeningSocket.h"

#define MAX_UNDOLEVELS	200

enum eUndoType
{
	UT_BLOCK,
	UT_CLEAR,
	UT_INSERTLINE,
	UT_DELETELINE,
	UT_INSERTCOL,
	UT_DELETECOL,
	UT_INSERTCHAR,
	UT_DELETECHAR
};

class cUndoState
{
public:
	cUndoState();
	cUndoState(cCanvas* p_pSource, CRect p_rectSave, CPoint p_ptCursor, eUndoType p_UndoType, BOOL p_bEndState);
	cUndoState(const cUndoState& p_value);
	~cUndoState();

	cUndoState& operator=(const cUndoState& p_value);
	void Set(const cUndoState& p_value);

	CRect GetSaveRect() { return m_rectSave; }
	CRect GetUpdateRect() { return m_rectUpdate; }

	void Undo(cCanvas* p_pSource, CListeningSocket* p_pSocket);
	void Redo(cCanvas* p_pSource, CListeningSocket* p_pSocket);
	void SwapBuffers(cCanvas* p_pSource, CListeningSocket* p_pSocket);

	void DeleteLines(int p_iStart, int p_iCount);
	void DeleteColumns(int p_iStart, int p_iCount);

	void InsertLines(int p_iStart, int p_iCount);

	CPoint&		GetCursor() { return m_ptCursor; }
	BOOL		IsEndState() { return m_bEndState; }

private:
	BOOL		m_bIsUndo;
	BOOL		m_bEndState;
	CRect		m_rectSave;
	CRect		m_rectUpdate;
	CPoint		m_ptCursor;
	cCanvas*	m_pCanvas;
	eUndoType	m_UndoType;
};
typedef CList<cUndoState> cUndoList;
