using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Windows.Forms;
using System.Reflection;

namespace SimpleXB
{
	/// <summary>
	/// Summary description for About.
	/// </summary>
	public class About : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button bOkay;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.LinkLabel linkLabel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label lVersion;
		private System.Windows.Forms.Label lCopyright;
		private System.Windows.Forms.Label lTitle;
		private System.Windows.Forms.Label lDescription;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public About()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			Assembly asm = Assembly.GetExecutingAssembly();
			string resourceName = "SimpleXB.ico";
#if !SHARPDEVELOP
			resourceName = asm.GetName().Name + "." + resourceName;
#endif			
			Stream iconStream = asm.GetManifestResourceStream(resourceName);
			Icon i = new Icon(iconStream, 48, 48);
			
			pictureBox1.Image = i.ToBitmap();
			pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;

			AssemblyTitleAttribute title = (AssemblyTitleAttribute)asm.GetCustomAttributes(typeof(AssemblyTitleAttribute), true)[0];
			lTitle.Text = title.Title;

			Version v = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
			lVersion.Text = string.Format("{0}.{1} build {2}", v.Major, v.Minor, v.Build);
			
			AssemblyCopyrightAttribute copyright = (AssemblyCopyrightAttribute)asm.GetCustomAttributes(typeof(AssemblyCopyrightAttribute), true)[0];
			lCopyright.Text = copyright.Copyright;

			AssemblyDescriptionAttribute description = (AssemblyDescriptionAttribute)asm.GetCustomAttributes(typeof(AssemblyDescriptionAttribute), true)[0];
			lDescription.Text = description.Description;

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.bOkay = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.linkLabel1 = new System.Windows.Forms.LinkLabel();
			this.label1 = new System.Windows.Forms.Label();
			this.lTitle = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.lVersion = new System.Windows.Forms.Label();
			this.lCopyright = new System.Windows.Forms.Label();
			this.lDescription = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// bOkay
			// 
			this.bOkay.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.bOkay.Location = new System.Drawing.Point(248, 136);
			this.bOkay.Name = "bOkay";
			this.bOkay.TabIndex = 0;
			this.bOkay.Text = "OK";
			// 
			// groupBox1
			// 
			this.groupBox1.Location = new System.Drawing.Point(8, 120);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(320, 5);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(8, 16);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(48, 48);
			this.pictureBox1.TabIndex = 4;
			this.pictureBox1.TabStop = false;
			// 
			// linkLabel1
			// 
			this.linkLabel1.Location = new System.Drawing.Point(16, 96);
			this.linkLabel1.Name = "linkLabel1";
			this.linkLabel1.Size = new System.Drawing.Size(312, 16);
			this.linkLabel1.TabIndex = 6;
			this.linkLabel1.TabStop = true;
			this.linkLabel1.Text = "http://www.acid.org";
			this.linkLabel1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.linkLabel1.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.linkLabel1_LinkClicked);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(80, 40);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 16);
			this.label1.TabIndex = 7;
			this.label1.Text = "Version:";
			// 
			// lTitle
			// 
			this.lTitle.Location = new System.Drawing.Point(64, 16);
			this.lTitle.Name = "lTitle";
			this.lTitle.Size = new System.Drawing.Size(264, 16);
			this.lTitle.TabIndex = 8;
			this.lTitle.Text = "<title>";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(80, 64);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(56, 16);
			this.label3.TabIndex = 9;
			this.label3.Text = "Copyright:";
			// 
			// lVersion
			// 
			this.lVersion.Location = new System.Drawing.Point(136, 40);
			this.lVersion.Name = "lVersion";
			this.lVersion.Size = new System.Drawing.Size(192, 16);
			this.lVersion.TabIndex = 10;
			this.lVersion.Text = "<version>";
			// 
			// lCopyright
			// 
			this.lCopyright.Location = new System.Drawing.Point(136, 64);
			this.lCopyright.Name = "lCopyright";
			this.lCopyright.Size = new System.Drawing.Size(192, 16);
			this.lCopyright.TabIndex = 11;
			this.lCopyright.Text = "<copyright>";
			// 
			// lDescription
			// 
			this.lDescription.Location = new System.Drawing.Point(16, 144);
			this.lDescription.Name = "lDescription";
			this.lDescription.Size = new System.Drawing.Size(224, 16);
			this.lDescription.TabIndex = 12;
			this.lDescription.Text = "<description>";
			// 
			// About
			// 
			this.AcceptButton = this.bOkay;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.bOkay;
			this.ClientSize = new System.Drawing.Size(338, 175);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.lDescription,
																		  this.lCopyright,
																		  this.lVersion,
																		  this.label3,
																		  this.lTitle,
																		  this.label1,
																		  this.linkLabel1,
																		  this.pictureBox1,
																		  this.groupBox1,
																		  this.bOkay});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "About";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "About";
			this.ResumeLayout(false);

		}
		#endregion

		private void linkLabel1_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.acid.org");
		}


	}
}
