using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using SimpleXB.Drawing;

namespace SimpleXB
{
	/// <summary>
	/// Summary description for CharacterSetViewer.
	/// </summary>
	public class CharacterSetViewer : System.Windows.Forms.Form
	{
		private Page page;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button bOk;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public CharacterSetViewer(Page page)
		{
			this.page = page;
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			panel1.ClientSize = new Size(page.Font.Width * 32, page.Font.Height * 8);
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.bOk = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Location = new System.Drawing.Point(8, 8);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(256, 128);
			this.panel1.TabIndex = 0;
			this.panel1.Paint += new System.Windows.Forms.PaintEventHandler(this.panel1_Paint);
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Location = new System.Drawing.Point(8, 152);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(256, 4);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			// 
			// bOk
			// 
			this.bOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.bOk.Location = new System.Drawing.Point(184, 168);
			this.bOk.Name = "bOk";
			this.bOk.TabIndex = 2;
			this.bOk.Text = "&Ok";
			this.bOk.Click += new System.EventHandler(this.bOk_Click);
			// 
			// CharacterSetViewer
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(272, 196);
			this.Controls.Add(this.bOk);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.panel1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(280, 224);
			this.Name = "CharacterSetViewer";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "CharacterSet Viewer";
			this.ResumeLayout(false);

		}
		#endregion

		private void panel1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			try
			{
				Graphics g = e.Graphics;
				int fontWidth = page.Font.Width;
				int fontHeight = page.Font.Height;
			
				Rectangle rect = new Rectangle(0,0, 32*fontWidth, 8*fontHeight);
				Bitmap b = new Bitmap(rect.Width, rect.Height, PixelFormat.Format24bppRgb);
				BitmapData bd = b.LockBits(new Rectangle(0,0,rect.Width, rect.Height), ImageLockMode.WriteOnly, PixelFormat.Format24bppRgb);
				Drawing.Font font = page.Font;

				Point p = new Point(rect.Left / fontWidth, rect.Top / fontHeight);
				Point charp = new Point(rect.Left % fontWidth, rect.Top % fontHeight);
				unsafe
				{
					int startX = rect.Left / fontWidth;
					int startFontX = rect.Left % fontWidth;
					Color foreColor;
					Color backColor;
					Color col;
					bool[] ba;
					byte* pRow;
					int x;
					byte* pByte = (byte*)bd.Scan0;
					foreColor = Color.White;
					backColor = Color.Black;
					
					int character = 0;
					for (int y=bd.Height-1; y>=0; y--)
					{
						p.X = startX;
						charp.X = startFontX;
						if (character > 255) break;
						ba = font[character][charp.Y];
						pRow = pByte;
						int xcharacter = character;
						for (x=bd.Width-1; x>=0; x--)
						{
							col = (ba[charp.X]) ? foreColor :backColor;
							*(pRow++) = col.B;
							*(pRow++) = col.G;
							*(pRow++) = col.R;
							
							charp.X++;
							if (charp.X >= fontWidth)
							{
								charp.X = 0;
								xcharacter++;
								if (xcharacter > 255) break;
								ba = font[xcharacter][charp.Y];
							}
							
						}
						pByte += bd.Stride;
						charp.Y++;
						if (charp.Y >= fontHeight)
						{
							charp.Y = 0;
							character += bd.Width / fontWidth;
						}
					}
				}
				b.UnlockBits(bd);
				//g.DrawImage(b, rect.Left, rect.Top, rect.Width, rect.Height);
				g.DrawImageUnscaled(b, rect);
				b.Dispose();
			}
			catch (Exception ex)
			{
				throw new Exception("Paint error", ex);
			}
		
		}

		private void bOk_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

	}
}
