using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SimpleXB.Drawing;

namespace SimpleXB
{
	/// <summary>
	/// Summary description for ColourViewer.
	/// </summary>
	public class ColourViewer : System.Windows.Forms.Form
	{
		private int curColor = 0;
		private Page page;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button bOk;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbRed;
		private System.Windows.Forms.TextBox tbGreen;
		private System.Windows.Forms.TextBox tbBlue;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ColourViewer(Page page)
		{
			this.page = page;
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

			tbRed.DataBindings.Add("Text", this, "CurrentColor.R");
			tbGreen.DataBindings.Add("Text", this, "CurrentColor.G");
			tbBlue.DataBindings.Add("Text", this, "CurrentColor.B");
		}

		public Color CurrentColor
		{
			get { return page.Palette[curColor]; }
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.bOk = new System.Windows.Forms.Button();
			this.panel1 = new System.Windows.Forms.Panel();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.tbRed = new System.Windows.Forms.TextBox();
			this.tbGreen = new System.Windows.Forms.TextBox();
			this.tbBlue = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Location = new System.Drawing.Point(8, 104);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(264, 4);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			// 
			// bOk
			// 
			this.bOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.bOk.Location = new System.Drawing.Point(192, 120);
			this.bOk.Name = "bOk";
			this.bOk.TabIndex = 1;
			this.bOk.Text = "&Ok";
			this.bOk.Click += new System.EventHandler(this.bOk_Click);
			// 
			// panel1
			// 
			this.panel1.AutoScroll = true;
			this.panel1.AutoScrollMinSize = new System.Drawing.Size(256, 32);
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Location = new System.Drawing.Point(8, 8);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(260, 36);
			this.panel1.TabIndex = 2;
			this.panel1.Click += new System.EventHandler(this.panel1_Click);
			this.panel1.Paint += new System.Windows.Forms.PaintEventHandler(this.panel1_Paint);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(40, 23);
			this.label1.TabIndex = 3;
			this.label1.Text = "Red";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(88, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 23);
			this.label2.TabIndex = 4;
			this.label2.Text = "Green";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(168, 56);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(40, 23);
			this.label3.TabIndex = 5;
			this.label3.Text = "Blue";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbRed
			// 
			this.tbRed.Location = new System.Drawing.Point(48, 56);
			this.tbRed.Name = "tbRed";
			this.tbRed.ReadOnly = true;
			this.tbRed.Size = new System.Drawing.Size(40, 20);
			this.tbRed.TabIndex = 6;
			this.tbRed.Text = "";
			// 
			// tbGreen
			// 
			this.tbGreen.Location = new System.Drawing.Point(128, 56);
			this.tbGreen.Name = "tbGreen";
			this.tbGreen.ReadOnly = true;
			this.tbGreen.Size = new System.Drawing.Size(40, 20);
			this.tbGreen.TabIndex = 7;
			this.tbGreen.Text = "";
			// 
			// tbBlue
			// 
			this.tbBlue.Location = new System.Drawing.Point(208, 56);
			this.tbBlue.Name = "tbBlue";
			this.tbBlue.ReadOnly = true;
			this.tbBlue.Size = new System.Drawing.Size(40, 20);
			this.tbBlue.TabIndex = 8;
			this.tbBlue.Text = "";
			// 
			// ColourViewer
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(282, 150);
			this.Controls.Add(this.tbBlue);
			this.Controls.Add(this.tbGreen);
			this.Controls.Add(this.tbRed);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.bOk);
			this.Controls.Add(this.groupBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ColourViewer";
			this.ShowInTaskbar = false;
			this.Text = "Colour Viewer";
			this.ResumeLayout(false);

		}
		#endregion

		private void bOk_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void panel1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			Palette pal = page.Palette;
			Graphics g = e.Graphics;

			Rectangle rect = new Rectangle(0,0,16, 32);
			for (int i=0; i<pal.Size; i++)
			{
				Color foreColor = pal[i];
				g.FillRectangle(new SolidBrush(foreColor), rect);
				if (i == curColor) 
				{
					Rectangle r = rect;
					r.Inflate(-1, -1);
					ControlPaint.DrawFocusRectangle(g, r, foreColor, foreColor);
				}
				rect.X += 16;
			}
			
		}

		private void panel1_Click(object sender, System.EventArgs e)
		{
			Point p = panel1.PointToClient(Cursor.Position);
			curColor = p.X / 16;
			panel1.Invalidate();
			this.BindingContext[this].ResumeBinding();
		}
	}
}
