using System;
using System.Resources;
using System.Reflection;
using System.IO;
using System.Collections;
using System.Drawing;

namespace SimpleXB.Drawing
{
	public class Character
	{
		public bool[][] rows;

		public Character(int width, int height)
		{
			rows = new bool[height][];
			for (int i=0; i<rows.Length; i++)
			{
				rows[i] = new bool[width];
			}
		}

		public bool[] this[int index]
		{
			get { return rows[index]; }
		}

		public void Read(BinaryReader br)
		{
			foreach (bool[] b in rows)
			{
				byte currentRow = br.ReadByte();
				int currentBit = 128;
				int curBitOffset = 0;
				for (int x=0; x<b.Length; x++)
				{
					if (currentBit == 0) currentRow = br.ReadByte();
					b[curBitOffset] = (currentRow & currentBit) != 0;
					curBitOffset++;
					currentBit >>= 1;
				}
			}
		}

	}
	
	
	/// <summary>
	/// Summary description for Font.
	/// </summary>
	public class Font
	{
		public Character[] chars;
		private int width;
		private int height;
		public Font(int numChars, int width, int height)
		{
			chars = new Character[numChars];
			this.width = width;
			this.height = height;

			for (int i=0; i<numChars; i++)
			{
				chars[i] = new Character(width, height);
			}
		}

		public static Font GetStandard8x16()
		{
			Assembly asm = Assembly.GetExecutingAssembly();
			string resourceName = "font8x16.fnt";
#if !SHARPDEVELOP
			resourceName = asm.GetName().Name + "." + resourceName;
#endif			
			Stream fontStream = asm.GetManifestResourceStream(resourceName);
			BinaryReader br = new BinaryReader(fontStream);
			int width = br.ReadInt16();
			int height = br.ReadInt16();
			int nc = br.ReadInt16();
			Font f = new Font(nc, width, height);
			f.Load(br);
			return f;
		}

		public static Font GetStandard8x8()
		{
			Assembly asm = Assembly.GetExecutingAssembly();
			string resourceName = "font8x8.fnt";
#if !SHARPDEVELOP
			resourceName = asm.GetName().Name + "." + resourceName;
#endif			
			Stream fontStream = asm.GetManifestResourceStream(resourceName);
			BinaryReader br = new BinaryReader(fontStream);
			int width = br.ReadInt16();
			int height = br.ReadInt16();
			int nc = br.ReadInt16();
			Font f = new Font(nc, width, height);
			f.Load(br);
			return f;
		}

		public int Width
		{
			get { return width; }
		}

		public int Height
		{
			get { return height; }
		}

		public Character this[int index]
		{
			get { return chars[index]; }
			set { chars[index] = value; }
		}

		public void Load(BinaryReader br)
		{
			for (int i=0; i<chars.Length; i++)
			{
				chars[i].Read(br);
			}
		}
	}
}
