using System;
using System.Drawing;
using System.IO;
using SimpleXB.Formats;
using SimpleXB.Sauce;

namespace SimpleXB.Drawing
{
	/// <summary>
	/// Summary description for Page.
	/// </summary>
	public class Page
	{
		Font font;
		Palette pal;
		Canvas canvas;
		Sauce.Sauce sauce;
		bool nonBlink = false;

		public event EventHandler Loaded;

		public Page(Size canvasSize)
		{
			canvas = new MemoryCanvas(canvasSize);
			pal = Palette.GetDefaultPalette();
			font = Font.GetStandard8x16();
		}

		public Canvas Canvas
		{
			get { return canvas; }
		}

		public Size PixelSize
		{
			get { return new Size(canvas.CanvasSize.Width * font.Width, canvas.CanvasSize.Height*font.Height); }
		}
		
		public Palette Palette
		{
			get { return pal; }
			set { pal = value; }
		}

		public Font Font
		{
			get { return font; }
			set { font = value; }
		}

		public bool NonBlink
		{
			get { return nonBlink; }
			set { nonBlink = value; }
		}

		public Sauce.Sauce Sauce
		{
			get { return sauce; }
			set { sauce = value; }
		}


		public void Load(string filename)
		{
			// load the file!
			Format f = new FormatXBin();
			Canvas.Clear();
			FileStream fs = new FileStream(filename, FileMode.Open, FileAccess.Read);
			Sauce.SauceStream ss = new Sauce.SauceStream(fs, 1024); 
			this.sauce = ss.Sauce;
			try
			{
				f.Load(ss, this);
			}
			catch (Exception e)
			{
				throw new Exception("Error opening file", e);
			}
			finally
			{
				ss.Close();
				fs.Close();
			}
			if (Loaded != null) Loaded(this, new EventArgs());
		}
	}
}
