using System;
using System.Drawing;
using System.IO;

namespace SimpleXB.Drawing
{
	/// <summary>
	/// Summary description for Palette.
	/// </summary>
	public class Palette
	{
		private Color[] paletteList;

		public Palette()
		{
			paletteList = new Color[16];
		}
		public Palette(int size)
		{
			paletteList = new Color[size];
		}

		public static Palette GetDefaultPalette()
		{
			Palette pal = new Palette(16);
			pal[0] = Color.FromArgb(0,		0,		0);
			pal[1] = Color.FromArgb(0,		0,		171);
			pal[2] = Color.FromArgb(0,		171,	0);
			pal[3] = Color.FromArgb(0,		171,	171);
			pal[4] = Color.FromArgb(171,	0,		0);
			pal[5] = Color.FromArgb(171,	0,		171);
			pal[6] = Color.FromArgb(171,	87,		0);
			pal[7] = Color.FromArgb(171,	171,	171);
			pal[8] = Color.FromArgb(87,		87,		87);
			pal[9] = Color.FromArgb(87,		87,		255);
			pal[10] = Color.FromArgb(87,	255,	87);
			pal[11] = Color.FromArgb(87,	255,	255);
			pal[12] = Color.FromArgb(255,	87,		87);
			pal[13] = Color.FromArgb(255,	87,		255);
			pal[14] = Color.FromArgb(255,	255,	87);
			pal[15] = Color.FromArgb(255,	255,	255);
			return pal;
		}

		public void Load(BinaryReader br, int size)
		{
			this.Size = size;
			for (int i=0; i<size; i++)
			{
				int red = br.ReadByte() << 2;
				int green = br.ReadByte() << 2;
				int blue = br.ReadByte() << 2;
				this[i] = Color.FromArgb(red, green, blue);
			}
		}

		public int Size
		{
			get { return paletteList.Length; }
			set { paletteList = new Color[value]; }
		}

		public Color this[int color]
		{
			get { return paletteList[color]; }
			set { paletteList[color] = value; }
		}

	}
}
