using System;
using System.IO;

namespace SimpleXB.Sauce
{
	public class SauceStream : Stream
	{
		Stream stream;
		Sauce sauce;

		public SauceStream(Stream stream, int bufferSize)
		{
			this.stream = stream;
			if (Sauce.SauceExists(stream))
			{
				sauce = new Sauce(stream, true);
			}
			else sauce = null;
		}
		public override bool CanRead
		{
			get { return true; }
		}

		public override bool CanSeek
		{
			get { return false; }
		}

		public override bool CanWrite
		{
			get { return false; }
		}

		public override void Flush() { stream.Flush(); }

		public override long Length { get { return (sauce != null) ? sauce.FileSize : stream.Length; } }
		public override long Position 
		{
			get { return stream.Position; } 
			set { stream.Position = value; }
		}

		public override int Read(byte[] array, int offset, int count)
		{
			return stream.Read(array, offset, count);
		}

		public override long Seek(long offset, SeekOrigin origin)
		{
			return stream.Seek(offset, origin);
		}

		public override void SetLength(long value)
		{
			throw new Exception("Cannot set length on a sauce stream");
		}

		public override void Write(byte[] array, int offset, int count)
		{
			stream.Write(array, offset, count);
		}

		public Sauce Sauce
		{
			get { return sauce; }
			set { sauce = value; }
		}

	}
}
