using System;

namespace SimpleXB.Sauce
{
	public enum XBinFileType
	{
		XBin = 0,		/* XBin format file
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of lines in the file.
						 */
	}

	/// <summary>
	/// Summary description for XBinDataTypeInfo.
	/// </summary>
	public class XBinDataTypeInfo : SauceDataTypeInfo
	{
		public XBinDataTypeInfo(Sauce sauce) : base(sauce)
		{
		}

		public XBinFileType Type
		{
			get 
			{
				return (XBinFileType)Sauce.ByteFileType;
			}
			set { Sauce.ByteFileType = (byte)value; }
		}

		public override string FileTypeDescription
		{
			get
			{
				return Type.ToString();
			}
		}

		public override string GetTInfoDescription(int info)
		{
			switch (Type)
			{
				default:
				case XBinFileType.XBin:
					switch (info)
					{
						case 1:	return "Width";
						case 2: return "Height";
					}
					break;
			}
			return base.GetTInfoDescription(info);
		}


	}
}
