import { type DOMElement, type DOMNode, type TextNode } from './dom.js';
type Output = {
    /**
    Element width.
    */
    width: number;
    /**
    Element height.
    */
    height: number;
};
/**
Measure the dimensions of a particular `<Box>` element.
*/
declare const measureElement: (node: DOMElement) => Output;
/**
 * Get an element's inner width.
 */
export declare const getInnerWidth: (node: DOMElement) => number;
export declare const getInnerHeight: (node: DOMElement) => number;
/**
 * Get an element's position and dimensions relative to the root.
 */
export declare const getBoundingBox: (node: DOMElement) => {
    x: number;
    y: number;
    width: number;
    height: number;
};
export type ScrollbarBoundingBox = {
    x: number;
    y: number;
    width: number;
    height: number;
    thumb: {
        x: number;
        y: number;
        width: number;
        height: number;
        start: number;
        end: number;
        startHalf: number;
        endHalf: number;
    };
};
export declare function calculateScrollbarThumb(options: {
    scrollbarDimension: number;
    clientDimension: number;
    scrollDimension: number;
    scrollPosition: number;
    axis: 'vertical' | 'horizontal';
}): {
    startIndex: number;
    endIndex: number;
    thumbStartHalf: number;
    thumbEndHalf: number;
};
/**
 * Get the bounding box of the vertical scrollbar.
 */
export declare const getVerticalScrollbarBoundingBox: (node: DOMElement, offset?: {
    x: number;
    y: number;
}) => ScrollbarBoundingBox | undefined;
/**
 * Get the bounding box of the horizontal scrollbar.
 */
export declare const getHorizontalScrollbarBoundingBox: (node: DOMElement, offset?: {
    x: number;
    y: number;
}) => ScrollbarBoundingBox | undefined;
export type TextFragment = {
    node: DOMElement;
    text: string;
    x: number;
    y: number;
    visualX: number;
    visualY: number;
    width: number;
    height: number;
};
export declare const collectSortedFragments: (node: DOMNode) => {
    fragments: TextFragment[];
    removedVertical: number;
    removedHorizontal: number;
};
export declare const getText: (node: DOMNode) => string;
export declare const getTextOffset: (node: DOMNode, x: number, y: number, options?: {
    snapToGap?: "start" | "end";
    snapToChar?: "start" | "end";
}) => number;
export declare const findNodeAtOffset: (node: DOMNode, targetOffset: number) => {
    node: TextNode;
    offset: number;
} | undefined;
export declare const hitTest: (node: DOMElement, x: number, y: number) => {
    node: DOMNode;
    offset: number;
} | undefined;
export default measureElement;
