/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.ee8.nested.AsyncContextEvent;
import org.eclipse.jetty.ee8.nested.AsyncContextState;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.CrossContextServletContext;
import org.eclipse.jetty.ee8.nested.HttpChannel;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.ee8.nested.Response;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelState {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final AutoLock _lock = new AutoLock();
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state = State.IDLE;
    private RequestState _requestState = RequestState.BLOCKING;
    private OutputState _outputState = OutputState.OPEN;
    private InputState _inputState = InputState.IDLE;
    private boolean _initial = true;
    private boolean _sendError;
    private boolean _asyncWritePossible;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;
    private Thread _onTimeoutThread;
    private Throwable _failure;
    private boolean _failureListener;

    protected HttpChannelState(HttpChannel channel) {
        this._channel = channel;
    }

    AutoLock lock() {
        return this._lock.lock();
    }

    boolean isLockHeldByCurrentThread() {
        return this._lock.isHeldByCurrentThread();
    }

    public State getState() {
        try (AutoLock l = this.lock();){
            State state = this._state;
            return state;
        }
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        try (AutoLock l = this.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public void addListener(AsyncListener listener) {
        try (AutoLock l = this.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    public boolean hasListener(AsyncListener listener) {
        try (AutoLock ignored = this.lock();){
            if (this._asyncListeners == null) {
                boolean bl = false;
                return bl;
            }
            for (AsyncListener l : this._asyncListeners) {
                if (l == listener) {
                    boolean bl = true;
                    return bl;
                }
                if (!(l instanceof AsyncContextState.WrappedAsyncListener) || ((AsyncContextState.WrappedAsyncListener)l).getListener() != listener) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isSendError() {
        try (AutoLock l = this.lock();){
            boolean bl = this._sendError;
            return bl;
        }
    }

    public void setTimeout(long ms) {
        try (AutoLock l = this.lock();){
            this._timeoutMs = ms;
        }
    }

    public long getTimeout() {
        try (AutoLock l = this.lock();){
            long l2 = this._timeoutMs;
            return l2;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (AutoLock l = this.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (AutoLock l = this.lock();){
            String string = this.toStringLocked();
            return string;
        }
    }

    private String toStringLocked() {
        return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getStatusStringLocked());
    }

    private String getStatusStringLocked() {
        return String.format("s=%s rs=%s os=%s is=%s awp=%b se=%b i=%b al=%d", new Object[]{this._state, this._requestState, this._outputState, this._inputState, this._asyncWritePossible, this._sendError, this._initial, this._asyncListeners == null ? 0 : this._asyncListeners.size()});
    }

    public String getStatusString() {
        try (AutoLock l = this.lock();){
            String string = this.getStatusStringLocked();
            return string;
        }
    }

    public boolean commitResponse() {
        try (AutoLock l = this.lock();){
            switch (this._outputState.ordinal()) {
                case 0: {
                    this._outputState = OutputState.COMMITTED;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean partialResponse() {
        try (AutoLock l = this.lock();){
            switch (this._outputState.ordinal()) {
                case 1: {
                    this._outputState = OutputState.OPEN;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public Throwable completeResponse() {
        try (AutoLock l = this.lock();){
            if (this._outputState == OutputState.OPEN || this._outputState == OutputState.COMMITTED) {
                this._outputState = OutputState.COMPLETED;
            }
            Throwable throwable = this._failure;
            return throwable;
        }
    }

    public boolean isResponseCommitted() {
        try (AutoLock l = this.lock();){
            switch (this._outputState.ordinal()) {
                case 0: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean isResponseCompleted() {
        try (AutoLock l = this.lock();){
            boolean bl = this._outputState == OutputState.COMPLETED;
            return bl;
        }
    }

    Boolean abort(Throwable failure) {
        try (AutoLock ignored = this.lock();){
            boolean aborted = this.abortResponse(failure);
            if (LOG.isDebugEnabled()) {
                LOG.debug("abort={} {}", new Object[]{aborted, this, failure});
            }
            if (aborted) {
                boolean handle;
                boolean bl = handle = this._state == State.WAITING;
                if (handle) {
                    this._state = State.WOKEN;
                }
                this._requestState = RequestState.COMPLETED;
                Boolean bl2 = handle;
                return bl2;
            }
            Boolean bl = null;
            return bl;
        }
    }

    public boolean abortResponse(Throwable failure) {
        try (AutoLock l = this.lock();){
            switch (this._outputState.ordinal()) {
                case 2: 
                case 3: {
                    boolean bl = false;
                    return bl;
                }
            }
            this._outputState = OutputState.ABORTED;
            this._failure = failure;
            boolean bl = true;
            return bl;
        }
    }

    public Action handling() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("handling {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 0: {
                    if (this._requestState != RequestState.BLOCKING) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._initial = true;
                    this._state = State.HANDLING;
                    Action action = Action.DISPATCH;
                    return action;
                }
                case 3: {
                    if (this._event != null && this._event.getThrowable() != null && !this._sendError) {
                        this._state = State.HANDLING;
                        Action action = Action.ASYNC_ERROR;
                        return action;
                    }
                    Action action = this.nextAction(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nextAction(true) {} {}", (Object)action, (Object)this.toStringLocked());
                    }
                    Action action2 = action;
                    return action2;
                }
            }
            throw new IllegalStateException(this.getStatusStringLocked());
        }
    }

    protected Action unhandle() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("unhandle {}", (Object)this.toStringLocked());
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._initial = false;
            Action action = this.nextAction(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("nextAction(false) {} {}", (Object)action, (Object)this.toStringLocked());
            }
            Action action2 = action;
            return action2;
        }
    }

    private Action nextAction(boolean handling) {
        this._state = State.HANDLING;
        if (this._sendError) {
            switch (this._requestState.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    this._requestState = RequestState.BLOCKING;
                    this._sendError = false;
                    return Action.SEND_ERROR;
                }
            }
        }
        switch (this._requestState.ordinal()) {
            case 0: {
                if (handling) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case 1: {
                switch (this._inputState.ordinal()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        this._inputState = InputState.IDLE;
                        return Action.READ_CALLBACK;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                if (this._asyncWritePossible) {
                    this._asyncWritePossible = false;
                    return Action.WRITE_CALLBACK;
                }
                Scheduler scheduler = this._channel.getScheduler();
                if (scheduler != null && this._timeoutMs > 0L && !this._event.hasTimeoutTask()) {
                    this._event.setTimeoutTask(scheduler.schedule((Runnable)this._event, this._timeoutMs, TimeUnit.MILLISECONDS));
                }
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case 2: {
                this._requestState = RequestState.BLOCKING;
                return Action.ASYNC_DISPATCH;
            }
            case 3: {
                this._requestState = RequestState.EXPIRING;
                return Action.ASYNC_TIMEOUT;
            }
            case 4: {
                if (handling) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this.sendError(500, "AsyncContext timeout");
                this._requestState = RequestState.BLOCKING;
                this._sendError = false;
                return Action.SEND_ERROR;
            }
            case 5: {
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case 6: {
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case 7: {
                this._state = State.IDLE;
                return Action.TERMINATED;
            }
        }
        throw new IllegalStateException(this.getStatusStringLocked());
    }

    public void startAsync(final AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("startAsync {}", (Object)this.toStringLocked());
            }
            if (this._state != State.HANDLING || this._requestState != RequestState.BLOCKING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (!this._failureListener) {
                this._failureListener = true;
                this.getHttpChannel().getCoreRequest().addFailureListener(this::asyncError);
            }
            this._requestState = RequestState.ASYNC;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            Runnable callback = new Runnable(){
                final /* synthetic */ HttpChannelState this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    for (AsyncListener listener : lastAsyncListeners) {
                        try {
                            listener.onStartAsync((AsyncEvent)event);
                        }
                        catch (Throwable e) {
                            LOG.warn("Async dispatch error", e);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext(event, callback);
        }
    }

    public void dispatch(ServletContext context, String path) {
        AsyncContextEvent event;
        boolean dispatch = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatch {} -> {}", (Object)this.toStringLocked(), (Object)path);
            }
            switch (this._requestState.ordinal()) {
                case 1: {
                    break;
                }
                case 4: {
                    if (Thread.currentThread() == this._onTimeoutThread) break;
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (context != null) {
                this._event.setDispatchContext(context);
            }
            if (path != null) {
                this._event.setDispatchPath(path);
            }
            if (this._requestState == RequestState.ASYNC && this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
            this._requestState = RequestState.DISPATCH;
            event = this._event;
        }
        this.cancelTimeout(event);
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    protected void timeout() {
        boolean dispatch = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timeout {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.ASYNC) {
                return;
            }
            this._requestState = RequestState.EXPIRE;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
        }
        if (dispatch) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", (Object)this);
            }
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimeout() {
        List<AsyncListener> listeners;
        AsyncContextEvent event;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTimeout {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.EXPIRING || this._state != State.HANDLING) {
                throw new IllegalStateException(this.toStringLocked());
            }
            event = this._event;
            listeners = this._asyncListeners;
            this._onTimeoutThread = Thread.currentThread();
        }
        try {
            if (listeners != null) {
                Runnable task = new Runnable(){
                    final /* synthetic */ HttpChannelState this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        for (AsyncListener listener : listeners) {
                            try {
                                listener.onTimeout((AsyncEvent)event);
                            }
                            catch (Throwable x) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} while invoking onTimeout listener {}", new Object[]{x.toString(), listener, x});
                                    continue;
                                }
                                LOG.warn("{} while invoking onTimeout listener {}", (Object)x.toString(), (Object)listener);
                            }
                        }
                    }

                    public String toString() {
                        return "onTimeout";
                    }
                };
                this.runInContext(event, task);
            }
        }
        finally {
            l = this.lock();
            try {
                this._onTimeoutThread = null;
            }
            finally {
                if (l != null) {
                    l.close();
                }
            }
        }
    }

    public void complete() {
        AsyncContextEvent event;
        boolean handle = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("complete {}", (Object)this.toStringLocked());
            }
            event = this._event;
            switch (this._requestState.ordinal()) {
                case 4: {
                    if (Thread.currentThread() != this._onTimeoutThread) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case 1: {
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (this._state == State.WAITING) {
                handle = true;
                this._state = State.WOKEN;
            }
        }
        this.cancelTimeout(event);
        if (handle) {
            this.runInContext(event, this._channel);
        }
    }

    public void asyncError(Throwable failure) {
        AsyncContextEvent event = null;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("asyncError {}", (Object)this.toStringLocked(), (Object)failure);
            }
            if (this._state == State.WAITING && this._requestState == RequestState.ASYNC) {
                this._state = State.WOKEN;
                this._event.addThrowable(failure);
                event = this._event;
            } else {
                if (!(failure instanceof QuietException)) {
                    LOG.warn(failure.toString());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Async error", failure);
                }
            }
        }
        if (event != null) {
            this.cancelTimeout(event);
            this.runInContext(event, this._channel);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean onError(Throwable th) {
        committed = this._channel.isCommitted();
        l = this.lock();
        try {
            if (HttpChannelState.LOG.isDebugEnabled()) {
                HttpChannelState.LOG.debug("onError {}", (Object)this.getStatusStringLocked(), (Object)th);
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (this._sendError) {
                HttpChannelState.LOG.warn("onError not handled due to prior sendError() {}", (Object)this.getStatusStringLocked(), (Object)th);
                var6_4 = false;
                return var6_4;
            }
            switch (this._requestState.ordinal()) {
                case 0: {
                    if (committed) {
                        var6_5 = true;
                        return var6_5;
                    }
                    this.sendError(th);
                    var6_6 = false;
                    return var6_6;
                }
                case 1: 
                case 2: 
                case 5: {
                    if (this._asyncListeners == null || this._asyncListeners.isEmpty()) {
                        var6_7 = false;
                        return var6_7;
                    }
                    asyncEvent = this._event;
                    asyncEvent.addThrowable(th);
                    asyncListeners = this._asyncListeners;
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                default: {
                    HttpChannelState.LOG.warn("onError not handled due to invalid requestState {}", (Object)this.getStatusStringLocked(), (Object)th);
                    var6_8 = true;
                    return var6_8;
                }
            }
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        this.runInContext(asyncEvent, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onError$0(java.util.List org.eclipse.jetty.ee8.nested.AsyncContextEvent ), ()V)(asyncListeners, (AsyncContextEvent)asyncEvent));
        l = this.lock();
        try {
            if (this._requestState == RequestState.ASYNC && !this._sendError) {
                if (committed) {
                    var6_10 = true;
                    return var6_10;
                }
                this.sendError(th);
                var6_11 = false;
                return var6_11;
            }
            if (this._requestState != RequestState.COMPLETE) {
                if (QuietException.isQuiet((Throwable)th)) {
                    HttpChannelState.LOG.debug("unhandled in state {}", (Object)this._requestState, (Object)th);
                } else {
                    HttpChannelState.LOG.warn("unhandled in state {}", (Object)this._requestState, (Object)th);
                }
            }
            var6_12 = committed;
            return var6_12;
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
    }

    private void sendError(Throwable th) {
        String message;
        int code;
        assert (this._lock.isHeldByCurrentThread());
        Request request = this._channel.getRequest();
        Throwable cause = this._channel.unwrap(th, HttpException.class, UnavailableException.class);
        if (cause == null) {
            code = 500;
            message = th.toString();
        } else if (cause instanceof HttpException) {
            HttpException httpException = (HttpException)cause;
            code = httpException.getCode();
            message = httpException.getReason();
        } else if (cause instanceof UnavailableException) {
            message = cause.toString();
            code = ((UnavailableException)cause).isPermanent() ? 404 : 503;
        } else {
            code = 500;
            message = null;
        }
        this.sendError(code, message);
        request.setAttribute("javax.servlet.error.exception", th);
        request.setAttribute("javax.servlet.error.exception_type", th.getClass());
        this._requestState = RequestState.BLOCKING;
    }

    public void sendError(int code, String message) {
        Request request = this._channel.getRequest();
        Response response = this._channel.getResponse();
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        try (AutoLock l = this.lock();){
            Throwable cause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendError {}", (Object)this.toStringLocked());
            }
            if (this._outputState != OutputState.OPEN) {
                throw new IllegalStateException(this._outputState.toString());
            }
            switch (this._state.ordinal()) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            response.setStatus(code);
            response.errorClose();
            ContextHandler.APIContext errorContext = request.getLastContext();
            request.setAttribute("org.eclipse.jetty.server.error_context", errorContext);
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
            request.setAttribute("javax.servlet.error.status_code", code);
            request.setAttribute("javax.servlet.error.message", message);
            this._sendError = true;
            if (this._event != null && (cause = (Throwable)request.getAttribute("javax.servlet.error.exception")) != null) {
                this._event.addThrowable(cause);
            }
        }
    }

    protected void completing() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("completing {}", (Object)this.toStringLocked());
            }
            switch (this._requestState.ordinal()) {
                case 7: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._requestState = RequestState.COMPLETING;
        }
    }

    protected void completed(Throwable failure) {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        boolean handle = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("completed {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.COMPLETING) {
                throw new IllegalStateException(this.getStatusStringLocked(), failure);
            }
            if (this._event == null) {
                this._requestState = RequestState.COMPLETED;
                aListeners = null;
                event = null;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            } else {
                aListeners = this._asyncListeners;
                event = this._event;
            }
        }
        this._channel.getResponse().getHttpOutput().completed(failure);
        if (event != null) {
            this.cancelTimeout(event);
            if (aListeners != null) {
                this.runInContext(event, () -> {
                    for (AsyncListener listener : aListeners) {
                        try {
                            listener.onComplete((AsyncEvent)event);
                        }
                        catch (Throwable x) {
                            if (LOG.isDebugEnabled()) {
                                LOG.warn("{} while invoking onComplete listener {}", new Object[]{x.toString(), listener, x});
                                continue;
                            }
                            LOG.warn("{} while invoking onComplete listener {}", (Object)x.toString(), (Object)listener);
                        }
                    }
                });
            }
            event.completed();
            l = this.lock();
            try {
                this._requestState = RequestState.COMPLETED;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            }
            finally {
                if (l != null) {
                    l.close();
                }
            }
        }
        if (handle) {
            this._channel.handle();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycle {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 1: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case 4: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._requestState = RequestState.BLOCKING;
            this._outputState = OutputState.OPEN;
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
            this._failureListener = false;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._requestState = RequestState.BLOCKING;
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void cancelTimeout() {
        this.cancelTimeout(this.getAsyncContextEvent());
    }

    protected void cancelTimeout(AsyncContextEvent event) {
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (AutoLock l = this.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (AutoLock l = this.lock();){
            boolean bl = this._requestState == RequestState.EXPIRE || this._requestState == RequestState.EXPIRING;
            return bl;
        }
    }

    public boolean isInitial() {
        try (AutoLock l = this.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (AutoLock l = this.lock();){
            boolean bl = this._state == State.WAITING || this._state == State.HANDLING && this._requestState == RequestState.ASYNC;
            return bl;
        }
    }

    boolean isCompleted() {
        try (AutoLock l = this.lock();){
            boolean bl = this._requestState == RequestState.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (AutoLock l = this.lock();){
            if (this._state == State.HANDLING) {
                boolean bl = this._requestState != RequestState.BLOCKING;
                return bl;
            }
            boolean bl = this._requestState == RequestState.ASYNC || this._requestState == RequestState.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (AutoLock l = this.lock();){
            boolean bl = !this._initial || this._requestState != RequestState.BLOCKING;
            return bl;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        return this.getContextHandler(this.getAsyncContextEvent());
    }

    ContextHandler getContextHandler(AsyncContextEvent event) {
        if (event != null) {
            CrossContextServletContext crossContextServletContext;
            org.eclipse.jetty.server.handler.ContextHandler contextHandler;
            ServletContext servletContext = event.getServletContext();
            if (servletContext instanceof CrossContextServletContext && (contextHandler = (crossContextServletContext = (CrossContextServletContext)servletContext).getTargetContext().getContextHandler()) instanceof ContextHandler.CoreContextHandler) {
                ContextHandler.CoreContextHandler coreContextHandler = (ContextHandler.CoreContextHandler)contextHandler;
                return coreContextHandler.getContextHandler();
            }
            if (servletContext instanceof ContextHandler.APIContext) {
                ContextHandler.APIContext apiContext = (ContextHandler.APIContext)servletContext;
                return apiContext.getContextHandler();
            }
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        return this.getServletResponse(this.getAsyncContextEvent());
    }

    public ServletResponse getServletResponse(AsyncContextEvent event) {
        if (event != null && event.getSuppliedResponse() != null) {
            return event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    void runInContext(AsyncContextEvent event, Runnable runnable) {
        ContextHandler contextHandler = this.getContextHandler(event);
        if (contextHandler == null) {
            runnable.run();
        } else {
            contextHandler.handle(this._channel.getRequest(), runnable);
        }
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onReadReady() {
        boolean woken = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadReady {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 2: {
                    this._inputState = InputState.READY;
                    return woken;
                }
                case 0: 
                case 1: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) return woken;
                    woken = true;
                    this._state = State.WOKEN;
                    return woken;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onReadEof() {
        boolean woken = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadEof {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) return woken;
                    woken = true;
                    this._state = State.WOKEN;
                    return woken;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onContentAdded() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onContentAdded {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.READY;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReadIdle() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadIdle {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.IDLE;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReadUnready() {
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadUnready {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.UNREADY;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    public boolean isInputUnready() {
        try (AutoLock l = this.lock();){
            boolean bl = this._inputState == InputState.UNREADY;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean wake = false;
        try (AutoLock l = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onWritePossible {}", (Object)this.toStringLocked());
            }
            this._asyncWritePossible = true;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                wake = true;
            }
        }
        return wake;
    }

    private static /* synthetic */ void lambda$onError$0(List asyncListeners, AsyncContextEvent asyncEvent) {
        for (AsyncListener listener : asyncListeners) {
            try {
                listener.onError((AsyncEvent)asyncEvent);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} while invoking onError listener {}", new Object[]{x, listener, x});
                    continue;
                }
                LOG.warn("{} while invoking onError listener {}", (Object)x, (Object)listener);
            }
        }
    }

    public static enum State {
        IDLE,
        HANDLING,
        WAITING,
        WOKEN,
        UPGRADED;

    }

    private static enum RequestState {
        BLOCKING,
        ASYNC,
        DISPATCH,
        EXPIRE,
        EXPIRING,
        COMPLETE,
        COMPLETING,
        COMPLETED;

    }

    private static enum OutputState {
        OPEN,
        COMMITTED,
        COMPLETED,
        ABORTED;

    }

    private static enum InputState {
        IDLE,
        UNREADY,
        READY;

    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        SEND_ERROR,
        ASYNC_ERROR,
        ASYNC_TIMEOUT,
        WRITE_CALLBACK,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }
}

